/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.serialization.java.compiler;

import com.intellij.util.xmlb.XmlSerializer;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.JpsProject;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerOptions;
import org.jetbrains.jps.model.java.compiler.RmicCompilerOptions;
import org.jetbrains.jps.model.serialization.JpsProjectExtensionSerializer;

public class RmicCompilerOptionsSerializer
extends JpsProjectExtensionSerializer {
    private final String myCompilerId;

    public RmicCompilerOptionsSerializer(String componentName, String compilerId) {
        super("compiler.xml", componentName);
        this.myCompilerId = compilerId;
    }

    @Override
    public void loadExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/RmicCompilerOptionsSerializer", "loadExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/RmicCompilerOptionsSerializer", "loadExtension"));
        }
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        RmicCompilerOptions options = (RmicCompilerOptions)XmlSerializer.deserialize((Element)componentTag, RmicCompilerOptions.class);
        configuration.setCompilerOptions(this.myCompilerId, (JpsJavaCompilerOptions)options);
    }

    @Override
    public void loadExtensionWithDefaultSettings(@NotNull JpsProject project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/RmicCompilerOptionsSerializer", "loadExtensionWithDefaultSettings"));
        }
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(project);
        configuration.setCompilerOptions(this.myCompilerId, (JpsJavaCompilerOptions)new RmicCompilerOptions());
    }

    @Override
    public void saveExtension(@NotNull JpsProject project, @NotNull Element componentTag) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/jps/model/serialization/java/compiler/RmicCompilerOptionsSerializer", "saveExtension"));
        }
        if (componentTag == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentTag", "org/jetbrains/jps/model/serialization/java/compiler/RmicCompilerOptionsSerializer", "saveExtension"));
        }
    }
}

