/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX;

import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.util.ArrayUtil;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxEntryPoint
extends EntryPoint {
    public static final String INITIALIZE_METHOD_NAME = "initialize";
    public boolean ADD_JAVAFX_TO_ENTRIES = true;

    @NotNull
    public String getDisplayName() {
        if ("JavaFX Applications" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/JavaFxEntryPoint", "getDisplayName"));
        }
        return "JavaFX Applications";
    }

    public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
        if (refElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/javaFX/JavaFxEntryPoint", "isEntryPoint"));
        }
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/javaFX/JavaFxEntryPoint", "isEntryPoint"));
        }
        return this.isEntryPoint(psiElement);
    }

    public boolean isEntryPoint(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiElement", "org/jetbrains/plugins/javaFX/JavaFxEntryPoint", "isEntryPoint"));
        }
        if (psiElement instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)psiElement;
            int paramsCount = method.getParameterList().getParameters().length;
            String methodName = method.getName();
            PsiClass containingClass = method.getContainingClass();
            if (paramsCount == 1 && PsiType.VOID.equals((Object)method.getReturnType()) && "start".equals(methodName)) {
                return InheritanceUtil.isInheritor((PsiClass)containingClass, (boolean)true, (String)"javafx.application.Application");
            }
            if (paramsCount == 0 && INITIALIZE_METHOD_NAME.equals(methodName) && method.hasModifierProperty("public") && containingClass != null && JavaFxPsiUtil.isControllerClass(containingClass)) {
                return true;
            }
        } else if (psiElement instanceof PsiClass) {
            return InheritanceUtil.isInheritor((PsiClass)((PsiClass)psiElement), (boolean)true, (String)"javafx.application.Application");
        }
        return false;
    }

    public boolean isSelected() {
        return this.ADD_JAVAFX_TO_ENTRIES;
    }

    public void setSelected(boolean selected) {
        this.ADD_JAVAFX_TO_ENTRIES = selected;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)((Object)this), (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        if (!this.ADD_JAVAFX_TO_ENTRIES) {
            DefaultJDOMExternalizer.writeExternal((Object)((Object)this), (Element)element);
        }
    }

    public String[] getIgnoreAnnotations() {
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }
}

