/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.codeInsight;

import com.intellij.codeInsight.intention.LowPriorityAction;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.impl.PsiDiamondTypeUtil;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptor;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.siyeh.ig.psiutils.ParenthesesUtils;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxCommonNames;
import org.jetbrains.plugins.javaFX.fxml.JavaFxModuleUtil;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxFieldToPropertyIntention
extends PsiElementBaseIntentionAction
implements LowPriorityAction {
    private static final Logger LOG = Logger.getInstance(JavaFxFieldToPropertyIntention.class);
    public static final String FAMILY_NAME = "Convert to JavaFX property";

    @Nls
    @NotNull
    public String getFamilyName() {
        if (FAMILY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention", "getFamilyName"));
        }
        return FAMILY_NAME;
    }

    @NotNull
    public String getText() {
        if (FAMILY_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention", "getText"));
        }
        return FAMILY_NAME;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        PsiFile file;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention", "isAvailable"));
        }
        PsiField field = JavaFxFieldToPropertyIntention.getField(element);
        if (field != null && (JavaFxModuleUtil.isInJavaFxProject(file = field.getContainingFile()) || JavaFxPsiUtil.isJavaFxPackageImported(file))) {
            return PropertyInfo.createPropertyInfo(field, project) != null;
        }
        return false;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention", "invoke"));
        }
        PsiField field = JavaFxFieldToPropertyIntention.getField(element);
        LOG.assertTrue(field != null, (Object)"field");
        PropertyInfo property = PropertyInfo.createPropertyInfo(field, project);
        LOG.assertTrue(property != null, (Object)"propertyInfo");
        new SearchUsagesTask(project, property).queue();
    }

    @Nullable
    private static PsiField getField(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention", "getField"));
        }
        if (!(element instanceof PsiIdentifier)) {
            return null;
        }
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)element, PsiField.class);
        if (field == null) {
            return null;
        }
        if (field.getLanguage() != JavaLanguage.INSTANCE) {
            return null;
        }
        if (field.getTypeElement() == null) {
            return null;
        }
        if (field.hasModifierProperty("static") || field.hasModifierProperty("final")) {
            return null;
        }
        return field;
    }

    static class ObservableObject
    extends ObservableType {
        final PsiType myType;

        ObservableObject(@NotNull PsiType type) {
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableObject", "<init>"));
            }
            super("javafx.beans.property.SimpleObjectProperty<" + type.getCanonicalText() + ">");
            this.myType = type;
        }
    }

    static class ObservableList
    extends ObservableType {
        final PsiType myOriginalType;
        final PsiType myItemType;
        final Project myProject;

        ObservableList(@NotNull PsiType originalType, @NotNull PsiType itemType, @NotNull Project project) {
            if (originalType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalType", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList", "<init>"));
            }
            if (itemType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemType", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList", "<init>"));
            }
            super("javafx.beans.property.SimpleListProperty<" + itemType.getCanonicalText() + ">");
            this.myOriginalType = originalType;
            this.myItemType = itemType;
            this.myProject = project;
        }

        @Nullable
        private static ObservableType createObservableList(@NotNull PsiType type, @NotNull Project project) {
            PsiType itemType;
            PsiSubstitutor substitutor;
            PsiClass listClass;
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList", "createObservableList"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList", "createObservableList"));
            }
            PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)type);
            PsiClass fieldClass = resolveResult.getElement();
            if (fieldClass != null && (listClass = JavaPsiFacade.getInstance((Project)project).findClass("java.util.List", GlobalSearchScope.allScope((Project)project))) != null && (substitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)listClass, (PsiClass)fieldClass, (PsiSubstitutor)resolveResult.getSubstitutor())) != null && (itemType = substitutor.substitute(listClass.getTypeParameters()[0])) != null) {
                return new ObservableList(type, itemType, project);
            }
            return null;
        }

        @Override
        @Nullable
        TypeConversionDescriptor findSimpleAssignmentConversion(PsiAssignmentExpression expression) {
            return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.setAll($val$)", (PsiExpression)expression);
        }

        @Override
        @NotNull
        TypeConversionDescriptor getReadConversion(PsiExpression expression) {
            TypeConversionDescriptor typeConversionDescriptor = new TypeConversionDescriptor("$qualifier$", "$qualifier$.get()", expression){

                public PsiExpression replace(PsiExpression expression, @NotNull TypeEvaluator evaluator) {
                    PsiMethod method;
                    PsiTypeElement returnTypeElement;
                    PsiCodeBlock codeBlock;
                    PsiElement blockParent;
                    PsiReturnStatement returnStatement;
                    PsiElement statementParent;
                    if (evaluator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluator", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList$1", "replace"));
                    }
                    PsiExpression replaced = super.replace(expression, evaluator);
                    PsiElement parent = replaced.getParent();
                    if (parent instanceof PsiReturnStatement && (statementParent = (returnStatement = (PsiReturnStatement)parent).getParent()) instanceof PsiCodeBlock && (blockParent = (codeBlock = (PsiCodeBlock)statementParent).getParent()) instanceof PsiMethod && (returnTypeElement = (method = (PsiMethod)blockParent).getReturnTypeElement()) != null && myOriginalType.equals(method.getReturnType())) {
                        String text = "javafx.collections.ObservableList<" + myItemType.getCanonicalText() + ">";
                        PsiTypeElement newReturnTypeElement = JavaPsiFacade.getInstance((Project)myProject).getElementFactory().createTypeElementFromText(text, (PsiElement)method);
                        JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)myProject);
                        javaCodeStyleManager.shortenClassReferences(returnTypeElement.replace((PsiElement)newReturnTypeElement));
                    }
                    return replaced;
                }
            };
            if (typeConversionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableList", "getReadConversion"));
            }
            return typeConversionDescriptor;
        }
    }

    static class ObservableString
    extends ObservableType {
        ObservableString() {
            super("javafx.beans.property.SimpleStringProperty");
        }

        @Override
        @Nullable
        TypeConversionDescriptor findCompoundAssignmentConversion(@NotNull PsiType from, @NotNull PsiExpression expression, @NotNull String sign, @NotNull String binarySign) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableString", "findCompoundAssignmentConversion"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableString", "findCompoundAssignmentConversion"));
            }
            if (sign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableString", "findCompoundAssignmentConversion"));
            }
            if (binarySign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binarySign", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableString", "findCompoundAssignmentConversion"));
            }
            return new TypeConversionDescriptor("$qualifier$ " + sign + " $val$", "$qualifier$.set($qualifier$.get() " + binarySign + " ($val$))", expression);
        }
    }

    static class ObservablePrimitive
    extends ObservableType {
        final PsiPrimitiveType myType;

        ObservablePrimitive(@NotNull String text, @NotNull PsiPrimitiveType type) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "<init>"));
            }
            if (type == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "<init>"));
            }
            super(text);
            this.myType = type;
        }

        @Override
        @Nullable
        TypeConversionDescriptor findCompoundAssignmentConversion(@NotNull PsiType from, @NotNull PsiExpression expression, @NotNull String sign, @NotNull String binarySign) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "findCompoundAssignmentConversion"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "findCompoundAssignmentConversion"));
            }
            if (sign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "findCompoundAssignmentConversion"));
            }
            if (binarySign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binarySign", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "findCompoundAssignmentConversion"));
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)from);
            String valueType = (unboxedType != null ? unboxedType : from).getCanonicalText();
            return new TypeConversionDescriptor("$qualifier$ " + sign + " $val$", "$qualifier$.set((" + valueType + ")($qualifier$.get() " + binarySign + " ($val$)))", expression);
        }

        @Override
        @Nullable
        TypeConversionDescriptor getUpdateConversion(@NotNull PsiExpression expression, @NotNull PsiJavaToken operationToken, boolean postfix) {
            IElementType tokenType;
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "getUpdateConversion"));
            }
            if (operationToken == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationToken", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservablePrimitive", "getUpdateConversion"));
            }
            PsiElement parent = ParenthesesUtils.getParentSkipParentheses((PsiElement)expression);
            if (parent instanceof PsiExpressionStatement && ((tokenType = operationToken.getTokenType()) == JavaTokenType.PLUSPLUS || tokenType == JavaTokenType.MINUSMINUS)) {
                String sign = operationToken.getText();
                return new TypeConversionDescriptor(postfix ? "$qualifier$" + sign : sign + "$qualifier$", "$qualifier$.set($qualifier$.get()" + sign.charAt(0) + "1)", expression);
            }
            return null;
        }
    }

    static class ObservableType {
        final String myText;

        ObservableType(@NotNull String text) {
            if (text == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "<init>"));
            }
            this.myText = text;
        }

        @Nullable
        static ObservableType createObservableType(@NotNull PsiField field, @NotNull Project project) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "createObservableType"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "createObservableType"));
            }
            PsiType type = field.getType();
            if (type instanceof PsiPrimitiveType) {
                String text = JavaFxCommonNames.ourObservablePrimitiveWrappers.get(type);
                return text != null ? new ObservablePrimitive(text, (PsiPrimitiveType)type) : null;
            }
            PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type);
            if (unboxedType != null) {
                String text = JavaFxCommonNames.ourObservablePrimitiveWrappers.get(unboxedType);
                return text != null ? new ObservablePrimitive(text, unboxedType) : null;
            }
            if (type.equalsToText("java.lang.String")) {
                return new ObservableString();
            }
            if (type instanceof PsiClassType) {
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"javafx.beans.Observable")) {
                    return null;
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.List")) {
                    return ObservableList.createObservableList(type, project);
                }
                if (InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Collection") || InheritanceUtil.isInheritor((PsiType)type, (String)"java.util.Map")) {
                    return null;
                }
                return new ObservableObject(type);
            }
            return null;
        }

        TypeConversionDescriptor findDirectConversion(@NotNull PsiElement context, @NotNull PsiType to, @NotNull PsiType from) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "findDirectConversion"));
            }
            if (to == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "findDirectConversion"));
            }
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "findDirectConversion"));
            }
            PsiClass toTypeClass = PsiUtil.resolveClassInType((PsiType)to);
            LOG.assertTrue(toTypeClass != null);
            PsiElement parent = context.getParent();
            if (parent instanceof PsiAssignmentExpression) {
                PsiAssignmentExpression expression = (PsiAssignmentExpression)parent;
                IElementType tokenType = expression.getOperationTokenType();
                if (tokenType == JavaTokenType.EQ) {
                    return this.findSimpleAssignmentConversion(expression);
                }
                String sign = expression.getOperationSign().getText();
                String binarySign = sign.substring(0, sign.length() - 1);
                return this.findCompoundAssignmentConversion(from, (PsiExpression)expression, sign, binarySign);
            }
            if (parent instanceof PsiPostfixExpression) {
                PsiPostfixExpression expression = (PsiPostfixExpression)parent;
                TypeConversionDescriptor conversion = this.getUpdateConversion((PsiExpression)expression, expression.getOperationSign(), true);
                if (conversion != null) {
                    return conversion;
                }
            } else if (parent instanceof PsiPrefixExpression) {
                PsiPrefixExpression expression = (PsiPrefixExpression)parent;
                TypeConversionDescriptor conversion = this.getUpdateConversion((PsiExpression)expression, expression.getOperationSign(), false);
                if (conversion != null) {
                    return conversion;
                }
            } else if (context instanceof PsiReferenceExpression) {
                PsiExpression qualifierExpression = ((PsiReferenceExpression)context).getQualifierExpression();
                PsiExpression expression = context.getParent() instanceof PsiMethodCallExpression && qualifierExpression != null ? qualifierExpression : (PsiExpression)context;
                return this.getReadConversion(expression);
            }
            return null;
        }

        @Nullable
        TypeConversionDescriptor findSimpleAssignmentConversion(PsiAssignmentExpression expression) {
            return new TypeConversionDescriptor("$qualifier$ = $val$", "$qualifier$.set($val$)", (PsiExpression)expression);
        }

        @Nullable
        TypeConversionDescriptor findCompoundAssignmentConversion(@NotNull PsiType from, @NotNull PsiExpression expression, @NotNull String sign, @NotNull String binarySign) {
            if (from == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "findCompoundAssignmentConversion"));
            }
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "findCompoundAssignmentConversion"));
            }
            if (sign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sign", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "findCompoundAssignmentConversion"));
            }
            if (binarySign == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binarySign", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "findCompoundAssignmentConversion"));
            }
            return null;
        }

        @Nullable
        TypeConversionDescriptor getUpdateConversion(@NotNull PsiExpression expression, @NotNull PsiJavaToken operationToken, boolean postfix) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "getUpdateConversion"));
            }
            if (operationToken == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "operationToken", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "getUpdateConversion"));
            }
            return null;
        }

        @NotNull
        TypeConversionDescriptor getReadConversion(PsiExpression expression) {
            TypeConversionDescriptor typeConversionDescriptor = new TypeConversionDescriptor("$qualifier$", "$qualifier$.get()", expression);
            if (typeConversionDescriptor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$ObservableType", "getReadConversion"));
            }
            return typeConversionDescriptor;
        }
    }

    private static class PropertyInfo {
        final PsiField myField;
        final PsiClass myContainingClass;
        final PsiTypeElement myTypeElement;
        final String myFieldName;
        final ObservableType myObservableType;

        private PropertyInfo(@NotNull PsiField field, @NotNull PsiClass containingClass, @NotNull PsiTypeElement typeElement, @NotNull String fieldName, @NotNull ObservableType observableType) {
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo", "<init>"));
            }
            if (containingClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containingClass", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo", "<init>"));
            }
            if (typeElement == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeElement", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo", "<init>"));
            }
            if (fieldName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo", "<init>"));
            }
            if (observableType == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "observableType", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo", "<init>"));
            }
            this.myField = field;
            this.myContainingClass = containingClass;
            this.myTypeElement = typeElement;
            this.myFieldName = fieldName;
            this.myObservableType = observableType;
        }

        static PropertyInfo createPropertyInfo(@NotNull PsiField field, @NotNull Project project) {
            ObservableType observableType;
            if (field == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "field", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo", "createPropertyInfo"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$PropertyInfo", "createPropertyInfo"));
            }
            String fieldName = field.getName();
            PsiClass containingClass = field.getContainingClass();
            PsiTypeElement typeElement = field.getTypeElement();
            if (fieldName != null && containingClass != null && typeElement != null && (observableType = ObservableType.createObservableType(field, project)) != null) {
                return new PropertyInfo(field, containingClass, typeElement, fieldName, observableType);
            }
            return null;
        }

        private void convertField() {
            PsiJavaCodeReferenceElement classReference;
            Project project = this.myContainingClass.getProject();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
            PsiTypeElement newTypeElement = elementFactory.createTypeElementFromText(this.myObservableType.myText, (PsiElement)this.myField);
            this.myTypeElement.replace((PsiElement)newTypeElement);
            PsiExpression initializer = this.myField.getInitializer();
            String propertyName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(this.myFieldName, VariableKind.FIELD);
            String initializerArgs = "this,\"" + propertyName + "\"" + (initializer == null ? "" : "," + initializer.getText());
            String initializerText = "new " + this.myObservableType.myText + "(" + initializerArgs + ")";
            PsiNewExpression newInitializer = (PsiNewExpression)elementFactory.createExpressionFromText(initializerText, (PsiElement)this.myField);
            this.myField.setInitializer((PsiExpression)newInitializer);
            PsiType fieldType = this.myField.getType();
            if (PsiDiamondTypeUtil.canCollapseToDiamond((PsiNewExpression)newInitializer, (PsiNewExpression)newInitializer, (PsiType)fieldType) && (classReference = newInitializer.getClassOrAnonymousClassReference()) != null) {
                PsiDiamondTypeUtil.replaceExplicitWithDiamond((PsiElement)classReference.getParameterList());
            }
            this.myField.setInitializer((PsiExpression)newInitializer);
            JavaCodeStyleManager javaCodeStyleManager = JavaCodeStyleManager.getInstance((Project)project);
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
            codeStyleManager.reformat(javaCodeStyleManager.shortenClassReferences((PsiElement)this.myField));
        }
    }

    private static class SearchUsagesTask
    extends Task.Modal {
        private final PropertyInfo myProperty;
        private Collection<PsiReference> myReferences;
        private Set<PsiFile> myFiles;

        public SearchUsagesTask(@NotNull Project project, @NotNull PropertyInfo property) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$SearchUsagesTask", "<init>"));
            }
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$SearchUsagesTask", "<init>"));
            }
            super(project, "Searching for usages of '" + property.myFieldName + "'", true);
            this.myProperty = property;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/javaFX/codeInsight/JavaFxFieldToPropertyIntention$SearchUsagesTask", "run"));
            }
            ReadAction.run(() -> {
                this.myReferences = ReferencesSearch.search((PsiElement)this.myProperty.myField).findAll();
                THashSet occurrences = new THashSet();
                occurrences.add(this.myProperty.myField);
                occurrences.addAll(ContainerUtil.mapNotNull(this.myReferences, PsiReference::getElement));
                this.myFiles = ContainerUtil.map2SetNotNull((Collection)occurrences, element -> {
                    PsiFile file = element.getContainingFile();
                    return file != null && file.isPhysical() ? file : null;
                });
            });
            WriteCommandAction.runWriteCommandAction((Project)this.myProject, (String)("Convert '" + this.myProperty.myFieldName + "' to JavaFX property"), null, this::replaceOccurrences, (PsiFile[])this.myFiles.toArray(PsiFile.EMPTY_ARRAY));
        }

        private void replaceOccurrences() {
            LOG.assertTrue(this.myProject != null, (Object)"myProject");
            PsiField field = this.myProperty.myField;
            field.normalizeDeclaration();
            PsiElementFactory elementFactory = JavaPsiFacade.getInstance((Project)this.myProject).getElementFactory();
            PsiType fromType = field.getType();
            PsiType toType = elementFactory.createTypeFromText(this.myProperty.myObservableType.myText, (PsiElement)field);
            try {
                TypeMigrationRules rules = new TypeMigrationRules();
                Set virtualFiles = ContainerUtil.map2SetNotNull(this.myFiles, PsiFile::getVirtualFile);
                rules.setBoundScope((SearchScope)GlobalSearchScope.filesScope((Project)this.myProject, (Collection)virtualFiles));
                TypeMigrationLabeler labeler = new TypeMigrationLabeler(rules, toType);
                labeler.getMigratedUsages(false, new PsiElement[]{field});
                for (PsiReference reference : this.myReferences) {
                    PsiExpression expression;
                    TypeConversionDescriptor conversion;
                    PsiElement refElement = reference.getElement();
                    if (!(refElement instanceof PsiExpression) || (conversion = this.myProperty.myObservableType.findDirectConversion((PsiElement)(expression = (PsiExpression)refElement), toType, fromType)) == null) continue;
                    TypeMigrationReplacementUtil.replaceExpression((PsiExpression)expression, (Project)this.myProject, (Object)conversion, (TypeEvaluator)new TypeEvaluator(null, null));
                }
                this.myProperty.convertField();
            }
            catch (IncorrectOperationException e) {
                LOG.error((Throwable)e);
            }
        }
    }
}

