/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeConsumer;
import com.intellij.openapi.fileTypes.FileTypeFactory;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class JavaFxFileTypeFactory
extends FileTypeFactory {
    @NonNls
    public static final String FXML_EXTENSION = "fxml";
    @NonNls
    static final String DOT_FXML_EXTENSION = ".fxml";

    public static boolean isFxml(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory", "isFxml"));
        }
        VirtualFile virtualFile = file.getViewProvider().getVirtualFile();
        return JavaFxFileTypeFactory.isFxml(virtualFile);
    }

    public static boolean isFxml(@NotNull VirtualFile virtualFile) {
        FileType fileType;
        if (virtualFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory", "isFxml"));
        }
        if (FXML_EXTENSION.equals(virtualFile.getExtension()) && (fileType = virtualFile.getFileType()) == JavaFxFileTypeFactory.getFileType() && !fileType.isBinary()) {
            return virtualFile.getName().endsWith(DOT_FXML_EXTENSION);
        }
        return false;
    }

    @NotNull
    public static FileType getFileType() {
        FileType fileType = FileTypeManager.getInstance().getFileTypeByExtension(FXML_EXTENSION);
        if (fileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory", "getFileType"));
        }
        return fileType;
    }

    public void createFileTypes(@NotNull FileTypeConsumer consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "consumer", "org/jetbrains/plugins/javaFX/fxml/JavaFxFileTypeFactory", "createFileTypes"));
        }
        FileType fileType = consumer.getStandardFileTypeByName("XML");
        assert (fileType != null);
        consumer.consume(fileType, FXML_EXTENSION);
    }
}

