/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions;

import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.XmlElementFactory;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxClassTagDescriptorBase;
import org.jetbrains.plugins.javaFX.fxml.descriptors.JavaFxPropertyTagDescriptor;

public class JavaFxCollapseSubTagToAttributeIntention
extends PsiElementBaseIntentionAction {
    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxCollapseSubTagToAttributeIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxCollapseSubTagToAttributeIntention", "invoke"));
        }
        XmlTag tag = (XmlTag)element.getParent();
        String value = tag.getSubTags().length == 0 ? tag.getValue().getText().trim() : StringUtil.join((Object[])tag.getSubTags(), childTag -> {
            XmlAttribute valueAttr = childTag.getAttribute("fx:value");
            if (valueAttr != null) {
                return valueAttr.getValue();
            }
            return "";
        }, (String)", ");
        XmlAttribute attribute = XmlElementFactory.getInstance((Project)project).createXmlAttribute(tag.getName(), value);
        XmlTag parentTag = tag.getParentTag();
        if (parentTag != null) {
            parentTag.add((PsiElement)attribute);
            tag.delete();
        }
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxCollapseSubTagToAttributeIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxCollapseSubTagToAttributeIntention", "isAvailable"));
        }
        if (element instanceof XmlToken && ((XmlToken)element).getTokenType() == XmlTokenType.XML_NAME && element.getParent() instanceof XmlTag) {
            XmlTag tag = (XmlTag)element.getParent();
            for (XmlTag xmlTag : tag.getSubTags()) {
                if (xmlTag.getAttribute("fx:value") != null) continue;
                return false;
            }
            XmlTag parentTag = tag.getParentTag();
            if (parentTag != null && tag.getDescriptor() instanceof JavaFxPropertyTagDescriptor && parentTag.getDescriptor() instanceof JavaFxClassTagDescriptorBase) {
                this.setText("Collapse tag '" + tag.getName() + "' to attribute");
                return true;
            }
        }
        return false;
    }

    @NotNull
    public String getFamilyName() {
        if ("Collapse tag to attribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxCollapseSubTagToAttributeIntention", "getFamilyName"));
        }
        return "Collapse tag to attribute";
    }
}

