/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.codeInsight.intentions;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.PsiElementBaseIntentionAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiParserFacade;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProcessingInstruction;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;

public class JavaFxInjectPageLanguageIntention
extends PsiElementBaseIntentionAction {
    public static final Logger LOG = Logger.getInstance((String)("#" + JavaFxInjectPageLanguageIntention.class.getName()));

    public static Set<String> getAvailableLanguages(Project project) {
        List<ScriptEngineFactory> engineFactories = new ScriptEngineManager(JavaFxInjectPageLanguageIntention.composeUserClassLoader(project)).getEngineFactories();
        if (engineFactories != null) {
            TreeSet<String> availableNames = new TreeSet<String>();
            for (ScriptEngineFactory factory : engineFactories) {
                String engineName = (String)factory.getParameter("javax.script.name");
                availableNames.add(engineName);
            }
            return availableNames;
        }
        return null;
    }

    private static ClassLoader composeUserClassLoader(Project project) {
        ArrayList<URL> urls = new ArrayList<URL>();
        List list = OrderEnumerator.orderEntries((Project)project).recursively().librariesOnly().runtimeOnly().getPathsList().getPathList();
        for (String path : list) {
            try {
                urls.add(new File(FileUtil.toSystemIndependentName((String)path)).toURI().toURL());
            }
            catch (MalformedURLException e1) {
                LOG.info((Throwable)e1);
            }
        }
        return new URLClassLoader(urls.toArray(new URL[urls.size()]));
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxInjectPageLanguageIntention", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxInjectPageLanguageIntention", "invoke"));
        }
        if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{element})) {
            return;
        }
        XmlFile containingFile = (XmlFile)element.getContainingFile();
        Set<String> availableLanguages = JavaFxInjectPageLanguageIntention.getAvailableLanguages(project);
        LOG.assertTrue(availableLanguages != null);
        if (availableLanguages.size() == 1) {
            this.registerPageLanguage(project, containingFile, availableLanguages.iterator().next());
        } else {
            JBList list = new JBList(availableLanguages);
            JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChoosenCallback(() -> {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxInjectPageLanguageIntention", "lambda$invoke$0"));
                }
                this.registerPageLanguage(project, containingFile, (String)list.getSelectedValue());
            }).createPopup().showInBestPositionFor(editor);
        }
    }

    public void registerPageLanguage(final Project project, final XmlFile containingFile, final String languageName) {
        new WriteCommandAction.Simple(project, this.getFamilyName(), new PsiFile[0]){

            protected void run() {
                PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
                XmlFile dummyFile = (XmlFile)factory.createFileFromText("_Dummy_.fxml", (FileType)StdFileTypes.XML, (CharSequence)("<?language " + languageName + "?>"));
                XmlDocument document = dummyFile.getDocument();
                if (document != null) {
                    XmlProlog xmlProlog;
                    XmlProlog prolog = document.getProlog();
                    Collection instructions = PsiTreeUtil.findChildrenOfType((PsiElement)prolog, XmlProcessingInstruction.class);
                    LOG.assertTrue(instructions.size() == 1);
                    XmlDocument xmlDocument = containingFile.getDocument();
                    if (xmlDocument != null && (xmlProlog = xmlDocument.getProlog()) != null) {
                        PsiElement element = xmlProlog.addBefore((PsiElement)instructions.iterator().next(), xmlProlog.getFirstChild());
                        xmlProlog.addAfter(PsiParserFacade.SERVICE.getInstance((Project)project).createWhiteSpaceFromText("\n\n"), element);
                    }
                }
            }
        }.execute();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxInjectPageLanguageIntention", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxInjectPageLanguageIntention", "isAvailable"));
        }
        if (ContainerUtil.isEmpty(JavaFxInjectPageLanguageIntention.getAvailableLanguages(project))) {
            return false;
        }
        this.setText(this.getFamilyName());
        return element.isValid();
    }

    @NotNull
    public String getFamilyName() {
        if ("Specify page language" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/codeInsight/intentions/JavaFxInjectPageLanguageIntention", "getFamilyName"));
        }
        return "Specify page language";
    }

    public boolean startInWriteAction() {
        return false;
    }
}

