/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.fxml.refs;

import com.intellij.codeInsight.daemon.QuickFixActionRegistrar;
import com.intellij.codeInsight.daemon.impl.quickfix.CreateMethodQuickFix;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.quickfix.UnresolvedReferenceQuickFixProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.javaFX.fxml.JavaFxPsiUtil;

public class JavaFxEventHandlerReference
extends PsiReferenceBase<XmlAttributeValue> {
    private final PsiMethod myEventHandler;
    private final PsiClass myController;

    public JavaFxEventHandlerReference(XmlAttributeValue element, PsiMethod method, PsiClass controller) {
        super((PsiElement)element);
        this.myEventHandler = method;
        this.myController = controller;
    }

    @Nullable
    public PsiElement resolve() {
        return this.myEventHandler;
    }

    @NotNull
    public Object[] getVariants() {
        if (this.myController == null) {
            if (EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference", "getVariants"));
            }
            return EMPTY_ARRAY;
        }
        ArrayList<PsiMethod> availableHandlers = new ArrayList<PsiMethod>();
        for (PsiMethod psiMethod : this.myController.getAllMethods()) {
            if (!JavaFxEventHandlerReference.isHandlerMethodSignature(psiMethod, this.myController) || !JavaFxPsiUtil.isVisibleInFxml((PsiMember)psiMethod)) continue;
            availableHandlers.add(psiMethod);
        }
        Object[] objectArray = availableHandlers.isEmpty() ? EMPTY_ARRAY : ArrayUtil.toObjectArray(availableHandlers);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference", "getVariants"));
        }
        return objectArray;
    }

    public static boolean isHandlerMethodSignature(@NotNull PsiMethod psiMethod, @NotNull PsiClass controllerClass) {
        if (psiMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiMethod", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference", "isHandlerMethodSignature"));
        }
        if (controllerClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "controllerClass", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference", "isHandlerMethodSignature"));
        }
        PsiClass containingClass = psiMethod.getContainingClass();
        if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName())) {
            return false;
        }
        if (!psiMethod.hasModifierProperty("static")) {
            PsiParameter[] parameters = psiMethod.getParameterList().getParameters();
            if (parameters.length == 1) {
                PsiType parameterType = parameters[0].getType();
                if (containingClass != null && !controllerClass.isEquivalentTo((PsiElement)containingClass)) {
                    PsiSubstitutor substitutor = TypeConversionUtil.getSuperClassSubstitutor((PsiClass)containingClass, (PsiClass)controllerClass, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                    parameterType = substitutor.substitute(parameterType);
                }
                if (InheritanceUtil.isInheritor((PsiType)parameterType, (String)"javafx.event.Event")) {
                    return true;
                }
            }
            return parameters.length == 0;
        }
        return false;
    }

    public TextRange getRangeInElement() {
        TextRange range = super.getRangeInElement();
        return new TextRange(range.getStartOffset() + 1, range.getEndOffset());
    }

    public static class JavaFxUnresolvedReferenceHandlerQuickfixProvider
    extends UnresolvedReferenceQuickFixProvider<JavaFxEventHandlerReference> {
        public void registerFixes(@NotNull JavaFxEventHandlerReference ref, @NotNull QuickFixActionRegistrar registrar) {
            CreateMethodQuickFix quickFix;
            if (ref == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ref", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "registerFixes"));
            }
            if (registrar == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "registerFixes"));
            }
            if (ref.myController != null && ref.myEventHandler == null && (quickFix = CreateMethodQuickFix.createFix((PsiClass)ref.myController, (String)JavaFxUnresolvedReferenceHandlerQuickfixProvider.getHandlerSignature(ref), (String)"")) != null) {
                registrar.register((IntentionAction)quickFix);
            }
        }

        private static String getHandlerSignature(JavaFxEventHandlerReference ref) {
            PsiClassType eventType;
            XmlAttributeValue element = (XmlAttributeValue)ref.getElement();
            String canonicalText = "javafx.event.Event";
            PsiElement parent = element.getParent();
            if (parent instanceof XmlAttribute && (eventType = JavaFxPsiUtil.getDeclaredEventType((XmlAttribute)parent)) != null) {
                canonicalText = eventType.getCanonicalText();
            }
            String modifiers = JavaFxUnresolvedReferenceHandlerQuickfixProvider.getModifiers(element.getProject());
            return modifiers + " void " + element.getValue().substring(1) + "(" + canonicalText + " e)";
        }

        @NotNull
        private static String getModifiers(@NotNull Project project) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "getModifiers"));
            }
            String visibility = CodeStyleSettingsManager.getSettings((Project)project).VISIBILITY;
            if ("EscalateVisible".equals(visibility)) {
                visibility = "private";
            }
            boolean needAnnotation = !"public".equals(visibility);
            String modifier = !"packageLocal".equals(visibility) ? visibility : "";
            String string = needAnnotation ? "@javafx.fxml.FXML " + modifier : modifier;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "getModifiers"));
            }
            return string;
        }

        @NotNull
        public Class<JavaFxEventHandlerReference> getReferenceClass() {
            if (JavaFxEventHandlerReference.class == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/fxml/refs/JavaFxEventHandlerReference$JavaFxUnresolvedReferenceHandlerQuickfixProvider", "getReferenceClass"));
            }
            return JavaFxEventHandlerReference.class;
        }
    }
}

