/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.javaFX.sceneBuilder;

import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.javaFX.sceneBuilder.SceneBuilderEditor;

public class SceneBuilderEditorProvider
implements FileEditorProvider,
DumbAware {
    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "accept"));
        }
        return "fxml".equalsIgnoreCase(file.getExtension()) && SystemInfo.isJavaVersionAtLeast((String)"1.8") && Registry.is((String)"embed.scene.builder");
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "createEditor"));
        }
        SceneBuilderEditor sceneBuilderEditor = new SceneBuilderEditor(project, file);
        if (sceneBuilderEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "createEditor"));
        }
        return sceneBuilderEditor;
    }

    @NotNull
    public String getEditorTypeId() {
        if ("JavaFX-Scene-Builder" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "getEditorTypeId"));
        }
        return "JavaFX-Scene-Builder";
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/plugins/javaFX/sceneBuilder/SceneBuilderEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

