/*
 * Decompiled with CFR 0.152.
 */
package org.junit.vintage.engine.execution;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestExecutionResult;
import org.junit.runner.Description;
import org.junit.vintage.engine.descriptor.RunnerTestDescriptor;
import org.junit.vintage.engine.descriptor.VintageTestDescriptor;
import org.opentest4j.MultipleFailuresError;

class TestRun {
    private final RunnerTestDescriptor runnerTestDescriptor;
    private final Logger logger;
    private final Set<? extends TestDescriptor> runnerDescendants;
    private final Map<Description, List<VintageTestDescriptor>> descriptionToDescriptors;
    private final Map<TestDescriptor, List<TestExecutionResult>> executionResults = new LinkedHashMap<TestDescriptor, List<TestExecutionResult>>();
    private final Set<TestDescriptor> skippedDescriptors = new LinkedHashSet<TestDescriptor>();
    private final Set<TestDescriptor> startedDescriptors = new LinkedHashSet<TestDescriptor>();
    private final Set<TestDescriptor> finishedDescriptors = new LinkedHashSet<TestDescriptor>();

    TestRun(RunnerTestDescriptor runnerTestDescriptor, Logger logger) {
        this.runnerTestDescriptor = runnerTestDescriptor;
        this.logger = logger;
        this.runnerDescendants = runnerTestDescriptor.getDescendants();
        this.descriptionToDescriptors = Stream.concat(Stream.of(runnerTestDescriptor), this.runnerDescendants.stream()).map(VintageTestDescriptor.class::cast).collect(Collectors.groupingBy(VintageTestDescriptor::getDescription));
    }

    RunnerTestDescriptor getRunnerTestDescriptor() {
        return this.runnerTestDescriptor;
    }

    boolean isDescendantOfRunnerTestDescriptor(TestDescriptor testDescriptor) {
        return this.runnerDescendants.contains(testDescriptor);
    }

    Optional<? extends TestDescriptor> lookupTestDescriptor(Description description) {
        Optional<? extends TestDescriptor> testDescriptor = this.lookupInternal(description);
        if (!testDescriptor.isPresent()) {
            this.logger.warning(() -> String.format("Runner %s on class %s reported event for unknown Description: %s. It will be ignored.", this.runnerTestDescriptor.getRunner().getClass().getName(), this.runnerTestDescriptor.getTestClass().getName(), description));
        }
        return testDescriptor;
    }

    private Optional<? extends TestDescriptor> lookupInternal(Description description) {
        List<VintageTestDescriptor> descriptors = this.descriptionToDescriptors.get(description);
        if (descriptors == null) {
            return Optional.empty();
        }
        if (descriptors.size() == 1) {
            return Optional.of(CollectionUtils.getOnlyElement(descriptors));
        }
        return descriptors.stream().filter(testDescriptor -> description == testDescriptor.getDescription()).findFirst();
    }

    void markSkipped(TestDescriptor testDescriptor) {
        this.skippedDescriptors.add(testDescriptor);
    }

    boolean isNotSkipped(TestDescriptor testDescriptor) {
        return !this.isSkipped(testDescriptor);
    }

    boolean isSkipped(TestDescriptor testDescriptor) {
        return this.skippedDescriptors.contains(testDescriptor);
    }

    void markStarted(TestDescriptor testDescriptor) {
        this.startedDescriptors.add(testDescriptor);
    }

    boolean isNotStarted(TestDescriptor testDescriptor) {
        return !this.startedDescriptors.contains(testDescriptor);
    }

    void markFinished(TestDescriptor testDescriptor) {
        this.finishedDescriptors.add(testDescriptor);
    }

    boolean isNotFinished(TestDescriptor testDescriptor) {
        return !this.isFinished(testDescriptor);
    }

    boolean isFinished(TestDescriptor testDescriptor) {
        return this.finishedDescriptors.contains(testDescriptor);
    }

    boolean areAllFinishedOrSkipped(Set<? extends TestDescriptor> testDescriptors) {
        return testDescriptors.stream().allMatch(this::isFinishedOrSkipped);
    }

    boolean isFinishedOrSkipped(TestDescriptor testDescriptor) {
        return this.isFinished(testDescriptor) || this.isSkipped(testDescriptor);
    }

    void storeResult(TestDescriptor testDescriptor, TestExecutionResult result) {
        List testExecutionResults = this.executionResults.computeIfAbsent(testDescriptor, key -> new ArrayList());
        testExecutionResults.add(result);
    }

    TestExecutionResult getStoredResultOrSuccessful(TestDescriptor testDescriptor) {
        List<TestExecutionResult> testExecutionResults = this.executionResults.get(testDescriptor);
        if (testExecutionResults == null) {
            return TestExecutionResult.successful();
        }
        if (testExecutionResults.size() == 1) {
            return testExecutionResults.get(0);
        }
        List failures = testExecutionResults.stream().map(TestExecutionResult::getThrowable).map(Optional::get).collect(Collectors.toList());
        return TestExecutionResult.failed((Throwable)new MultipleFailuresError("", failures));
    }
}

