/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.builders.impl;

import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;

public class BuildRootDescriptorImpl
extends BuildRootDescriptor {
    private final File myRoot;
    private final BuildTarget myTarget;
    private final boolean myCanUseFileCache;

    public BuildRootDescriptorImpl(BuildTarget target, File root) {
        this(target, root, false);
    }

    public BuildRootDescriptorImpl(BuildTarget target, File root, boolean canUseFileCache) {
        this.myTarget = target;
        this.myRoot = root;
        this.myCanUseFileCache = canUseFileCache;
    }

    @Override
    public String getRootId() {
        return FileUtilRt.toSystemIndependentName((String)this.myRoot.getAbsolutePath());
    }

    @Override
    public File getRootFile() {
        return this.myRoot;
    }

    @Override
    public BuildTarget<?> getTarget() {
        return this.myTarget;
    }

    @Override
    public boolean canUseFileCache() {
        return this.myCanUseFileCache;
    }
}

