/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.classFilesIndex.indexer.api;

import com.intellij.compiler.instrumentation.InstrumentationClassFinder;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.classFilesIndex.indexer.api.ClassFileIndexerFactory;
import org.jetbrains.jps.classFilesIndex.indexer.api.ClassFilesIndexWriter;
import org.jetbrains.jps.incremental.BinaryContent;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.CompiledClass;
import org.jetbrains.jps.incremental.instrumentation.BaseInstrumentingBuilder;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.org.objectweb.asm.ClassReader;
import org.jetbrains.org.objectweb.asm.ClassWriter;

public class ClassFilesIndicesBuilder
extends BaseInstrumentingBuilder {
    public static final Logger LOG = Logger.getInstance(ClassFilesIndicesBuilder.class);
    private static final String PRESENTABLE_NAME = "Class-files indexer";
    private static final String PROGRESS_MESSAGE = "Indexing class-files...";
    public static final String PROPERTY_NAME = "intellij.compiler.output.index";
    private final Collection<ClassFilesIndexWriter> myIndexWriters = new ArrayList<ClassFilesIndexWriter>();

    @Override
    public void buildStarted(CompileContext context) {
        super.buildStarted(context);
        boolean isEnabled = ClassFilesIndicesBuilder.isEnabled();
        LOG.info("class files data index " + (isEnabled ? "enabled" : "disabled"));
        if (!isEnabled) {
            return;
        }
        HashSet enabledIndicesBuilders = ContainerUtil.newHashSet((Object[])System.getProperty(PROPERTY_NAME).split(";"));
        boolean forcedRecompilation = JavaBuilderUtil.isForcedRecompilationAllJavaModules(context);
        Iterable extensions = JpsServiceManager.getInstance().getExtensions(ClassFileIndexerFactory.class);
        int newIndicesCount = 0;
        for (ClassFileIndexerFactory builder : extensions) {
            if (!enabledIndicesBuilders.contains(builder.getClass().getName())) continue;
            ClassFilesIndexWriter indexWriter = new ClassFilesIndexWriter(builder.create(), context);
            if (!indexWriter.isEmpty()) {
                this.myIndexWriters.add(indexWriter);
                continue;
            }
            if (forcedRecompilation) {
                ++newIndicesCount;
                this.myIndexWriters.add(indexWriter);
                continue;
            }
            indexWriter.close(context);
        }
        if (forcedRecompilation) {
            LOG.info(String.format("class files indexing: %d indices, %d new", this.myIndexWriters.size(), newIndicesCount));
        } else {
            LOG.info(String.format("class files indexing: %d indices", this.myIndexWriters.size()));
        }
    }

    @Override
    public void buildFinished(CompileContext context) {
        super.buildFinished(context);
        if (!ClassFilesIndicesBuilder.isEnabled()) {
            return;
        }
        for (ClassFilesIndexWriter index : this.myIndexWriters) {
            index.close(context);
        }
        this.myIndexWriters.clear();
    }

    @Override
    @Nullable
    protected BinaryContent instrument(CompileContext context, CompiledClass compiled, ClassReader reader, ClassWriter writer, InstrumentationClassFinder finder) {
        String className = compiled.getClassName();
        if (className == null) {
            LOG.debug("class name is empty for " + compiled.getOutputFile().getAbsolutePath());
        } else {
            className = className.replace('.', '/');
            for (ClassFilesIndexWriter index : this.myIndexWriters) {
                index.update(className, reader);
            }
        }
        return null;
    }

    @Override
    protected boolean canInstrument(CompiledClass compiledClass, int classFileVersion) {
        return !"module-info".equals(compiledClass.getClassName());
    }

    @Override
    protected boolean isEnabled(CompileContext context, ModuleChunk chunk) {
        return ClassFilesIndicesBuilder.isEnabled();
    }

    private static boolean isEnabled() {
        return System.getProperty(PROPERTY_NAME) != null;
    }

    @Override
    protected String getProgressMessage() {
        return PROGRESS_MESSAGE;
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if (PRESENTABLE_NAME == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/jps/classFilesIndex/indexer/api/ClassFilesIndicesBuilder", "getPresentableName"));
        }
        return PRESENTABLE_NAME;
    }
}

