/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.java;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public final class CopyResourcesUtil {
    private CopyResourcesUtil() {
    }

    public static File copyClass(String targetPath, @NonNls String className, boolean deleteOnExit) throws IOException {
        String resourceName;
        InputStream stream;
        File targetDir = new File(targetPath).getAbsoluteFile();
        File file = new File(targetDir, className + ".class");
        FileUtil.createParentDirs((File)file);
        if (deleteOnExit) {
            File f = file;
            while (f != null && !FileUtil.filesEqual((File)f, (File)targetDir)) {
                f.deleteOnExit();
                f = FileUtilRt.getParentFile((File)f);
            }
        }
        if ((stream = CopyResourcesUtil.class.getResourceAsStream(resourceName = "/" + className + ".class")) == null) {
            throw new IOException("cannot load " + resourceName);
        }
        return CopyResourcesUtil.copyStreamToFile(stream, file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File copyStreamToFile(InputStream stream, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            FileUtil.copy((InputStream)stream, (OutputStream)outputStream);
        }
        finally {
            stream.close();
        }
        return file;
    }

    public static void copyProperties(String targetPath, String fileName) throws IOException {
        File targetDir = new File(targetPath).getAbsoluteFile();
        File file = new File(targetDir, fileName);
        FileUtil.createParentDirs((File)file);
        File f = file;
        while (f != null && !FileUtil.filesEqual((File)f, (File)targetDir)) {
            f.deleteOnExit();
            f = FileUtilRt.getParentFile((File)f);
        }
        String resourceName = "/" + fileName;
        InputStream stream = CopyResourcesUtil.class.getResourceAsStream(resourceName);
        if (stream == null) {
            return;
        }
        CopyResourcesUtil.copyStreamToFile(stream, file);
    }

    public static List<File> copyFormsRuntime(String targetDir, boolean deleteOnExit) throws IOException {
        String[] runtimeClasses = new String[]{"AbstractLayout", "DimensionInfo", "GridConstraints", "GridLayoutManager", "HorizontalInfo", "LayoutState", "Spacer", "SupportCode$TextWithMnemonic", "SupportCode", "Util", "VerticalInfo"};
        ArrayList<File> copied = new ArrayList<File>();
        for (String runtimeClass : runtimeClasses) {
            copied.add(CopyResourcesUtil.copyClass(targetDir, "com/intellij/uiDesigner/core/" + runtimeClass, deleteOnExit));
        }
        return copied;
    }
}

