/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.indices.impl;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.jps.indices.ModuleExcludeIndex;
import org.jetbrains.jps.model.JpsModel;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaModuleExtension;
import org.jetbrains.jps.model.java.JpsJavaProjectExtension;
import org.jetbrains.jps.model.module.JpsModule;
import org.jetbrains.jps.model.module.JpsModuleSourceRoot;
import org.jetbrains.jps.util.JpsPathUtil;

public class ModuleExcludeIndexImpl
implements ModuleExcludeIndex {
    private final Set<File> myExcludedRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
    private final Set<File> myTopLevelContentRoots = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
    private final Map<JpsModule, ArrayList<File>> myModuleToExcludesMap = new THashMap();
    private final Map<JpsModule, List<File>> myModuleToContentMap = new THashMap();

    public ModuleExcludeIndexImpl(JpsModel model) {
        String url;
        List allModules = model.getProject().getModules();
        THashMap contentToModule = new THashMap(FileUtil.FILE_HASHING_STRATEGY);
        for (JpsModule module : allModules) {
            ArrayList<File> moduleExcludes = new ArrayList<File>();
            for (String string : module.getExcludeRootsList().getUrls()) {
                moduleExcludes.add(JpsPathUtil.urlToFile((String)string));
            }
            JpsJavaModuleExtension moduleExtension = JpsJavaExtensionService.getInstance().getModuleExtension(module);
            if (moduleExtension != null && !moduleExtension.isInheritOutput() && moduleExtension.isExcludeOutput()) {
                String testOutputUrl;
                String string = moduleExtension.getOutputUrl();
                if (string != null) {
                    moduleExcludes.add(JpsPathUtil.urlToFile((String)string));
                }
                if ((testOutputUrl = moduleExtension.getTestOutputUrl()) != null) {
                    moduleExcludes.add(JpsPathUtil.urlToFile((String)testOutputUrl));
                }
            }
            List list = module.getContentRootsList().getUrls();
            ArrayList<File> moduleContent = new ArrayList<File>(list.size());
            for (String contentUrl : list) {
                File contentRoot = JpsPathUtil.urlToFile((String)contentUrl);
                moduleContent.add(contentRoot);
                contentToModule.put(contentRoot, module);
            }
            for (JpsModuleSourceRoot root : module.getSourceRoots()) {
                File sourceRoot = root.getFile();
                moduleContent.add(sourceRoot);
                contentToModule.put(sourceRoot, module);
            }
            this.myModuleToExcludesMap.put(module, moduleExcludes);
            this.myModuleToContentMap.put(module, moduleContent);
            this.myExcludedRoots.addAll(moduleExcludes);
        }
        JpsJavaProjectExtension projectExtension = JpsJavaExtensionService.getInstance().getProjectExtension(model.getProject());
        if (projectExtension != null && !StringUtil.isEmpty((String)(url = projectExtension.getOutputUrl()))) {
            File excluded;
            File parent = excluded = JpsPathUtil.urlToFile((String)url);
            while (parent != null) {
                JpsModule jpsModule = (JpsModule)contentToModule.get(parent);
                if (jpsModule != null) {
                    this.myModuleToExcludesMap.get(jpsModule).add(excluded);
                }
                parent = FileUtil.getParentFile((File)parent);
            }
            this.myExcludedRoots.add(excluded);
        }
        ArrayList<File> parents = new ArrayList<File>();
        THashSet notUnderExcludedCache = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
        for (JpsModule jpsModule : allModules) {
            for (File contentRoot : this.myModuleToContentMap.get(jpsModule)) {
                Object parentModule = null;
                parents.clear();
                for (File parent = contentRoot.getParentFile(); parent != null; parent = parent.getParentFile()) {
                    parents.add(parent);
                    if (!contentToModule.containsKey(parent)) continue;
                    parentModule = (JpsModule)contentToModule.get(parent);
                    break;
                }
                if (parentModule != null) {
                    if (!parentModule.equals(jpsModule)) {
                        this.myModuleToExcludesMap.get(parentModule).add(contentRoot);
                    }
                    if (ModuleExcludeIndexImpl.isUnderExcluded(contentRoot, this.myExcludedRoots, (Set<File>)notUnderExcludedCache)) {
                        this.myTopLevelContentRoots.add(contentRoot);
                    }
                } else {
                    this.myTopLevelContentRoots.add(contentRoot);
                }
                for (File file : parents) {
                    contentToModule.put(file, parentModule);
                }
            }
        }
        for (List list : this.myModuleToExcludesMap.values()) {
            ((ArrayList)list).trimToSize();
        }
    }

    private static boolean isUnderExcluded(File root, Set<File> excluded, Set<File> notUnderExcludedCache) {
        ArrayList<File> parents = new ArrayList<File>();
        for (File parent = root; parent != null; parent = parent.getParentFile()) {
            if (notUnderExcludedCache.contains(parent)) {
                return false;
            }
            if (excluded.contains(parent)) {
                return true;
            }
            parents.add(parent);
        }
        notUnderExcludedCache.addAll(parents);
        return false;
    }

    @Override
    public boolean isExcluded(File file) {
        return ModuleExcludeIndexImpl.determineFileLocation(file, this.myTopLevelContentRoots, this.myExcludedRoots) == FileLocation.EXCLUDED;
    }

    @Override
    public boolean isExcludedFromModule(File file, JpsModule module) {
        return ModuleExcludeIndexImpl.determineFileLocation(file, (Collection<File>)this.myModuleToContentMap.get(module), (Collection<File>)this.myModuleToExcludesMap.get(module)) == FileLocation.EXCLUDED;
    }

    @Override
    public boolean isInContent(File file) {
        return ModuleExcludeIndexImpl.determineFileLocation(file, this.myTopLevelContentRoots, this.myExcludedRoots) == FileLocation.IN_CONTENT;
    }

    private static FileLocation determineFileLocation(File file, Collection<File> roots, Collection<File> excluded) {
        if (roots.isEmpty() && excluded.isEmpty()) {
            return FileLocation.NOT_IN_PROJECT;
        }
        File current = file;
        while (current != null) {
            if (excluded.contains(current)) {
                return FileLocation.EXCLUDED;
            }
            if (roots.contains(current)) {
                return FileLocation.IN_CONTENT;
            }
            current = FileUtilRt.getParentFile((File)current);
        }
        return FileLocation.NOT_IN_PROJECT;
    }

    @Override
    public Collection<File> getModuleExcludes(JpsModule module) {
        return this.myModuleToExcludesMap.get(module);
    }

    private static enum FileLocation {
        IN_CONTENT,
        EXCLUDED,
        NOT_IN_PROJECT;

    }
}

