/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.model;

import java.io.Serializable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MavenRemoteRepository
implements Serializable {
    private final String myId;
    private final String myName;
    private final String myUrl;
    private final String myLayout;
    private final Policy myReleasesPolicy;
    private final Policy mySnapshotsPolicy;

    public MavenRemoteRepository(@NotNull String id, @Nullable String name, @NotNull String url, @Nullable String layout, @Nullable Policy releasesPolicy, @Nullable Policy snapshotsPolicy) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "org/jetbrains/idea/maven/model/MavenRemoteRepository", "<init>"));
        }
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "org/jetbrains/idea/maven/model/MavenRemoteRepository", "<init>"));
        }
        this.myId = id;
        this.myName = name;
        this.myUrl = url;
        this.myLayout = layout;
        this.myReleasesPolicy = releasesPolicy;
        this.mySnapshotsPolicy = snapshotsPolicy;
    }

    @NotNull
    public String getId() {
        String string = this.myId;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/model/MavenRemoteRepository", "getId"));
        }
        return string;
    }

    @Nullable
    public String getName() {
        return this.myName;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/jetbrains/idea/maven/model/MavenRemoteRepository", "getUrl"));
        }
        return string;
    }

    @Nullable
    public String getLayout() {
        return this.myLayout;
    }

    @Nullable
    public Policy getReleasesPolicy() {
        return this.myReleasesPolicy;
    }

    @Nullable
    public Policy getSnapshotsPolicy() {
        return this.mySnapshotsPolicy;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MavenRemoteRepository that = (MavenRemoteRepository)o;
        return this.myId.equals(that.myId);
    }

    public int hashCode() {
        return this.myId.hashCode();
    }

    public static class Policy
    implements Serializable {
        private final boolean myEnabled;
        private final String myUpdatePolicy;
        private final String myChecksumPolicy;

        public Policy(boolean enabled, String updatePolicy, String checksumPolicy) {
            this.myEnabled = enabled;
            this.myUpdatePolicy = updatePolicy;
            this.myChecksumPolicy = checksumPolicy;
        }

        public boolean isEnabled() {
            return this.myEnabled;
        }

        public String getUpdatePolicy() {
            return this.myUpdatePolicy;
        }

        public String getChecksumPolicy() {
            return this.myChecksumPolicy;
        }
    }
}

