/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.sherpa.scout;

import android.support.constraint.solver.widgets.ConstraintWidget;
import com.android.tools.sherpa.scout.ScoutWidget;
import com.android.tools.sherpa.scout.Utils;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.BitSet;

class ScoutCandidateGroup {
    int mNorth;
    int mSouth;
    int mEast;
    int mWest;
    Rectangle mRect;
    BitSet mContainSet = new BitSet();
    int mWidgetArea;
    int mGroupArea;
    int mCount = 0;
    Rectangle[] mRectList;
    int mGapArea;
    int mRows;
    int mCols;
    boolean mValidTable = false;

    ScoutCandidateGroup() {
    }

    public static ScoutCandidateGroup create(Rectangle group, ScoutWidget[] list, Rectangle[] rectList) {
        BitSet set = new BitSet();
        int count = 0;
        int groupArea = group.width * group.height;
        int widgetArea = 0;
        for (int i = 1; i < list.length; ++i) {
            if (group.intersects(rectList[i]) && !group.contains(rectList[i])) {
                return null;
            }
            if (!group.contains(rectList[i])) continue;
            set.set(i);
            ++count;
            widgetArea += rectList[i].height * rectList[i].width;
        }
        if (count < 4) {
            return null;
        }
        if (widgetArea * 2 < groupArea) {
            return null;
        }
        ScoutCandidateGroup c = new ScoutCandidateGroup();
        c.mNorth = group.y;
        c.mSouth = group.y + group.height;
        c.mEast = group.x + group.width;
        c.mWest = group.x;
        c.mContainSet = set;
        c.mCount = count;
        c.mGroupArea = groupArea;
        c.mWidgetArea = widgetArea;
        c.mRect = new Rectangle(group);
        c.mRectList = ScoutCandidateGroup.buildRectList(set, rectList);
        return c;
    }

    public ArrayList<ConstraintWidget> buildList(ScoutWidget[] list) {
        ArrayList<ConstraintWidget> ret = new ArrayList<ConstraintWidget>();
        int i = this.mContainSet.nextSetBit(0);
        while (i >= 0) {
            ret.add(list[i].mConstraintWidget);
            i = this.mContainSet.nextSetBit(i + 1);
        }
        return ret;
    }

    private static Rectangle[] buildRectList(BitSet subset, Rectangle[] rectList) {
        Rectangle[] inside = new Rectangle[subset.cardinality()];
        int count = 0;
        int i = subset.nextSetBit(0);
        while (i >= 0) {
            inside[count++] = new Rectangle(rectList[i]);
            i = subset.nextSetBit(i + 1);
        }
        return inside;
    }

    public void computeGapAreas() {
        Rectangle gap = new Rectangle();
        int area = 0;
        for (int i = 0; i < this.mRectList.length; ++i) {
            Rectangle rectangleA = this.mRectList[i];
            for (int j = i + 1; j < this.mRectList.length; ++j) {
                Rectangle rectangleB = this.mRectList[j];
                boolean viable = ScoutCandidateGroup.calculateGap(rectangleA, rectangleB, gap);
                if (viable) {
                    for (int k = 0; k < this.mRectList.length; ++k) {
                        if (k == j || k == i || !gap.intersects(this.mRectList[k])) continue;
                        viable = false;
                        break;
                    }
                }
                if (!viable) continue;
                area += gap.width * gap.height;
            }
        }
        this.mGapArea = area;
    }

    public Rectangle[] computeGaps() {
        ArrayList<Rectangle> ret = new ArrayList<Rectangle>();
        Rectangle gap = new Rectangle();
        for (int i = 0; i < this.mRectList.length; ++i) {
            Rectangle rectangleA = this.mRectList[i];
            for (int j = i + 1; j < this.mRectList.length; ++j) {
                Rectangle rectangleB = this.mRectList[j];
                boolean viable = ScoutCandidateGroup.calculateGap(rectangleA, rectangleB, gap);
                if (viable) {
                    for (int k = 0; k < this.mRectList.length; ++k) {
                        if (k == j || k == i || !gap.intersects(this.mRectList[k])) continue;
                        viable = false;
                        break;
                    }
                }
                if (!viable) continue;
                ret.add(new Rectangle(gap));
            }
        }
        return ret.toArray(new Rectangle[ret.size()]);
    }

    private static boolean calculateGap(Rectangle a, Rectangle b, Rectangle gap) {
        if (a.intersects(b)) {
            gap.width = 0;
            return false;
        }
        int ax1 = a.x;
        int ax2 = a.x + a.width;
        int ay1 = a.y;
        int ay2 = a.y + a.height;
        int bx1 = b.x;
        int bx2 = b.x + b.width;
        int by1 = b.y;
        int by2 = b.y + b.height;
        int xOverlap = Math.min(ax2, bx2) - Math.max(ax1, bx1);
        int yOverlap = Math.min(ay2, by2) - Math.max(ay1, by1);
        if (xOverlap <= 0 && yOverlap <= 0) {
            gap.width = 0;
            return false;
        }
        if (xOverlap > 0) {
            gap.x = Math.max(ax1, bx1);
            gap.y = ay1 > by1 ? by2 : ay2;
            gap.width = xOverlap;
            gap.height = -yOverlap;
        }
        if (yOverlap > 0) {
            gap.x = ax1 > bx1 ? bx2 : ax2;
            gap.y = Math.max(ay1, by1);
            gap.width = -xOverlap;
            gap.height = yOverlap;
        }
        return true;
    }

    public float fractionFilled() {
        return (float)this.mWidgetArea / (float)this.mGroupArea;
    }

    public boolean contains(ScoutCandidateGroup candidate) {
        return this.mRect.contains(candidate.mRect);
    }

    public float calcProb() {
        float empty = this.mGroupArea - (this.mWidgetArea + this.mGapArea);
        empty /= (float)(this.mCount * this.mGroupArea);
        empty = 1.0f - empty;
        float tableProb = this.calculateTableConfidence(this.mRectList);
        return (tableProb + empty + (1.0f - 1.0f / (float)this.mCount)) / 3.0f;
    }

    public boolean viable() {
        return (float)(this.mWidgetArea + this.mGapArea) / (float)this.mGroupArea > 0.4f;
    }

    public float calculateTableConfidence(Rectangle[] widgets) {
        this.mValidTable = true;
        int[][] bounds = new int[4][widgets.length];
        for (int i = 0; i < widgets.length; ++i) {
            Rectangle widget = widgets[i];
            bounds[0][i] = widget.y;
            bounds[1][i] = bounds[0][i] + widget.height;
            bounds[2][i] = widget.x;
            bounds[3][i] = bounds[2][i] + widget.width;
        }
        this.mRows = Utils.gaps(bounds[0], bounds[1]);
        this.mCols = Utils.gaps(bounds[2], bounds[3]);
        int[] r = Utils.cells(bounds[0], bounds[1]);
        int[] c = Utils.cells(bounds[2], bounds[3]);
        Rectangle[][] table = new Rectangle[this.mCols][this.mRows];
        for (Rectangle widget : widgets) {
            int row = Utils.getPosition(r, widget.y, widget.y + widget.height);
            int col = Utils.getPosition(c, widget.x, widget.x + widget.width);
            if (row == -1 || col == -1) {
                this.mValidTable = false;
                return 0.0f;
            }
            table[col][row] = widget;
        }
        float sumprob = 0.0f;
        for (Rectangle[] rec : table) {
            float prob = ScoutCandidateGroup.alignmentProbability(rec);
            sumprob = prob + sumprob - sumprob * prob;
        }
        return sumprob;
    }

    private static float alignmentProbability(Rectangle[] widget) {
        float[] start = new float[widget.length];
        float[] center = new float[widget.length];
        float[] end = new float[widget.length];
        float widthSum = 0.0f;
        int count = 0;
        for (int i = 0; i < end.length; ++i) {
            if (widget[i] == null) {
                start[i] = Float.NaN;
                end[i] = Float.NaN;
                center[i] = Float.NaN;
                continue;
            }
            start[i] = widget[i].x;
            end[i] = start[i] + (float)widget[i].width;
            center[i] = (start[i] + end[i]) / 2.0f;
            widthSum += (float)widget[i].width;
            ++count;
        }
        float startDiv = ScoutCandidateGroup.standardDeviation(start);
        float centerDiv = ScoutCandidateGroup.standardDeviation(center);
        float endDiv = ScoutCandidateGroup.standardDeviation(end);
        if (count > 2) {
            return 1.0f - Math.min(startDiv, Math.min(centerDiv, endDiv)) / (widthSum / (float)count);
        }
        return 0.0f;
    }

    private static float standardDeviation(float[] pos) {
        float sum = 0.0f;
        float sumSqr = 0.0f;
        int count = 0;
        for (float po : pos) {
            if (Float.isNaN(po)) continue;
            ++count;
            sum += po;
            sumSqr += po * po;
        }
        return (float)Math.sqrt(sumSqr / (float)count - sum / (float)count * (sum / (float)count));
    }
}

