/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.google.common.base.Splitter;
import com.intellij.execution.process.ProcessOutput;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;

public class AndroidApplicationInfo {
    public static final AndroidApplicationInfo UNKNOWN = new AndroidApplicationInfo("unknown", "unknown");
    @NotNull
    public final String packageId;
    @NotNull
    public final String versionName;

    private AndroidApplicationInfo(@NotNull String packageId, @NotNull String versionName) {
        if (packageId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageId", "com/android/tools/idea/apk/viewer/AndroidApplicationInfo", "<init>"));
        }
        if (versionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "versionName", "com/android/tools/idea/apk/viewer/AndroidApplicationInfo", "<init>"));
        }
        this.packageId = packageId;
        this.versionName = versionName;
    }

    public static AndroidApplicationInfo fromXmlTree(@NotNull ProcessOutput xmlTree) {
        if (xmlTree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "xmlTree", "com/android/tools/idea/apk/viewer/AndroidApplicationInfo", "fromXmlTree"));
        }
        if (xmlTree.getExitCode() != 0) {
            return UNKNOWN;
        }
        return AndroidApplicationInfo.parse(xmlTree.getStdout());
    }

    @NotNull
    static AndroidApplicationInfo parse(@NotNull String output) {
        if (output == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "output", "com/android/tools/idea/apk/viewer/AndroidApplicationInfo", "parse"));
        }
        String packageId = null;
        String versionName = null;
        for (String line : Splitter.on((char)'\n').trimResults().split((CharSequence)output)) {
            int endQuote;
            int eqIndex;
            if (line.startsWith("A: android:versionName")) {
                eqIndex = line.indexOf("=");
                if (eqIndex > 0 && (endQuote = line.indexOf("\"", eqIndex + 2)) > 0) {
                    versionName = line.substring(eqIndex + 2, endQuote);
                }
            } else if (line.startsWith("A: package=") && (eqIndex = line.indexOf("=")) > 0 && (endQuote = line.indexOf("\"", eqIndex + 2)) > 0) {
                packageId = line.substring(eqIndex + 2, endQuote);
            }
            if (packageId == null || versionName == null) continue;
            break;
        }
        AndroidApplicationInfo androidApplicationInfo = new AndroidApplicationInfo(StringUtil.notNullize(packageId, (String)"unknown"), StringUtil.notNullize(versionName, (String)"?"));
        if (androidApplicationInfo == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/AndroidApplicationInfo", "parse"));
        }
        return androidApplicationInfo;
    }
}

