/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer;

import com.android.tools.idea.apk.AndroidApkFileType;
import com.android.tools.idea.apk.viewer.ApkEditor;
import com.android.tools.idea.apk.viewer.ApkFileSystem;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorPolicy;
import com.intellij.openapi.fileEditor.FileEditorProvider;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ApkEditorProvider
implements FileEditorProvider,
DumbAware {
    private static final String ID = "apk-viewer";

    public boolean accept(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "accept"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "accept"));
        }
        if (!file.getName().endsWith(AndroidApkFileType.INSTANCE.getDefaultExtension())) {
            return false;
        }
        return ApkFileSystem.getInstance().getRootByLocal(file) != null;
    }

    @NotNull
    public FileEditor createEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "createEditor"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "createEditor"));
        }
        VirtualFile root = ApkFileSystem.getInstance().getRootByLocal(file);
        assert (root != null);
        ApkEditor apkEditor = new ApkEditor(project, file, root);
        if (apkEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "createEditor"));
        }
        return apkEditor;
    }

    public void disposeEditor(@NotNull FileEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "disposeEditor"));
        }
        Disposer.dispose((Disposable)editor);
    }

    @NotNull
    public FileEditorState readState(@NotNull Element sourceElement, @NotNull Project project, @NotNull VirtualFile file) {
        if (sourceElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sourceElement", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "readState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "readState"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "readState"));
        }
        FileEditorState fileEditorState = FileEditorState.INSTANCE;
        if (fileEditorState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "readState"));
        }
        return fileEditorState;
    }

    public void writeState(@NotNull FileEditorState state, @NotNull Project project, @NotNull Element targetElement) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "writeState"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "writeState"));
        }
        if (targetElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "targetElement", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "writeState"));
        }
    }

    @NotNull
    public String getEditorTypeId() {
        if (ID == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "getEditorTypeId"));
        }
        return ID;
    }

    @NotNull
    public FileEditorPolicy getPolicy() {
        FileEditorPolicy fileEditorPolicy = FileEditorPolicy.PLACE_AFTER_DEFAULT_EDITOR;
        if (fileEditorPolicy == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/ApkEditorProvider", "getPolicy"));
        }
        return fileEditorPolicy;
    }
}

