/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.arsc;

import com.android.tools.idea.apk.viewer.arsc.ResourceTypeTableModel;
import com.google.common.collect.ImmutableList;
import com.google.devrel.gmscore.tools.apk.arsc.BinaryResourceFile;
import com.google.devrel.gmscore.tools.apk.arsc.PackageChunk;
import com.google.devrel.gmscore.tools.apk.arsc.ResourceTableChunk;
import com.google.devrel.gmscore.tools.apk.arsc.TypeSpecChunk;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Splitter;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.List;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;

public class ResourceTablePanel {
    private JPanel myContainer;
    private ComboBox myPackageCombo;
    private Splitter mySplitter;
    private JBList myTypesList;
    private JBTable myResourceTypeTable;
    private SimpleColoredComponent myResourceTableHeader;

    public ResourceTablePanel(@NotNull BinaryResourceFile resourceFile) {
        if (resourceFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceFile", "com/android/tools/idea/apk/viewer/arsc/ResourceTablePanel", "<init>"));
        }
        this.$$$setupUI$$$();
        List chunks = resourceFile.getChunks();
        if (chunks.isEmpty()) {
            throw new IllegalArgumentException("no chunks");
        }
        if (!(chunks.get(0) instanceof ResourceTableChunk)) {
            throw new IllegalArgumentException("no res table chunk");
        }
        ResourceTableChunk resourceTableChunk = (ResourceTableChunk)chunks.get(0);
        Collection packages = resourceTableChunk.getPackages();
        this.myPackageCombo.setModel((ComboBoxModel)new CollectionComboBoxModel((List)ImmutableList.copyOf((Collection)packages)));
        this.myPackageCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<PackageChunk>(){

            protected void customizeCellRenderer(JList list, PackageChunk value, int index, boolean selected, boolean hasFocus) {
                this.append(value.getPackageName());
            }
        });
        assert (packages.size() == 1);
        PackageChunk packageChunk = (PackageChunk)packages.stream().findFirst().get();
        this.myTypesList.setModel((ListModel)new CollectionListModel(packageChunk.getTypeSpecChunks()));
        this.myTypesList.setCellRenderer((ListCellRenderer)new ColoredListCellRenderer<TypeSpecChunk>(){

            protected void customizeCellRenderer(JList list, TypeSpecChunk value, int index, boolean selected, boolean hasFocus) {
                this.append(value.getTypeName());
            }
        });
        this.myTypesList.addListSelectionListener(e -> {
            Object selectedValue = this.myTypesList.getSelectedValue();
            if (!(selectedValue instanceof TypeSpecChunk)) {
                return;
            }
            TypeSpecChunk typeSpecChunk = (TypeSpecChunk)selectedValue;
            this.myResourceTypeTable.setModel((TableModel)new ResourceTypeTableModel(resourceTableChunk.getStringPool(), packageChunk, typeSpecChunk));
            this.myResourceTypeTable.getColumnModel().getColumn(0).setMinWidth(100);
            this.myResourceTypeTable.getColumnModel().getColumn(1).setMinWidth(250);
            int resourceCount = typeSpecChunk.getResourceCount();
            int configCount = packageChunk.getTypeChunks(typeSpecChunk.getId()).size();
            this.myResourceTableHeader.clear();
            this.myResourceTableHeader.append("There " + (resourceCount > 1 ? "are " : "is "));
            this.myResourceTableHeader.append(Integer.toString(resourceCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.myResourceTableHeader.append(" " + typeSpecChunk.getTypeName() + (resourceCount > 1 ? " resources" : " resource") + " across ");
            this.myResourceTableHeader.append(Integer.toString(configCount), SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            this.myResourceTableHeader.append(" configuration" + (configCount > 1 ? "s" : ""));
        });
    }

    private void createUIComponents() {
        JBLabel label = new JBLabel("Resource Types");
        this.myTypesList = new JBList();
        JPanel resourceTypesPanel = new JPanel(new BorderLayout());
        resourceTypesPanel.setBorder(IdeBorderFactory.createBorder((int)2));
        resourceTypesPanel.add((Component)label, "North");
        resourceTypesPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTypesList), "Center");
        this.myResourceTypeTable = new JBTable();
        this.myResourceTypeTable.setAutoResizeMode(0);
        this.myResourceTypeTable.getEmptyText().setText("No resource type selected.");
        this.myResourceTableHeader = new SimpleColoredComponent();
        JPanel resourceTablePanel = new JPanel(new BorderLayout());
        resourceTablePanel.setBorder(IdeBorderFactory.createBorder((int)2));
        resourceTablePanel.add((Component)this.myResourceTableHeader, "North");
        resourceTablePanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myResourceTypeTable), "Center");
        this.mySplitter = new OnePixelSplitter(false, 0.2f);
        this.mySplitter.setFirstComponent((JComponent)resourceTypesPanel);
        this.mySplitter.setSecondComponent((JComponent)resourceTablePanel);
    }

    public JComponent getPanel() {
        return this.myContainer;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        ComboBox comboBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myContainer = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new FlowLayout(0, 0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Package:");
        Component component = jPanel2.add((Component)jBLabel);
        this.myPackageCombo = comboBox = new ComboBox();
        Component component2 = jPanel2.add((Component)comboBox);
        Splitter splitter = this.mySplitter;
        jPanel.add((Component)splitter, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContainer;
    }
}

