/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.viewer.diff;

import com.android.tools.idea.apk.viewer.ApkEntry;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ApkDiffEntry
implements ApkEntry {
    private String myName;
    @Nullable
    private final VirtualFile myOldFile;
    @Nullable
    private final VirtualFile myNewFile;
    private final long myOldSize;
    private final long myNewSize;

    /*
     * WARNING - void declaration
     */
    ApkDiffEntry(@NotNull String name, @Nullable VirtualFile oldFile, @Nullable VirtualFile newFile, long oldSize, long l) {
        void newSize;
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/apk/viewer/diff/ApkDiffEntry", "<init>"));
        }
        this.myName = name;
        this.myOldFile = oldFile;
        this.myNewFile = newFile;
        this.myOldSize = oldSize;
        this.myNewSize = newSize;
    }

    @Override
    public boolean isCompressedSizeKnown() {
        return false;
    }

    @Override
    public long getCompressedSize() {
        return 0L;
    }

    @Override
    public void setCompressedSize(long compressedSize) {
    }

    @Override
    @NotNull
    public VirtualFile getFile() {
        if (this.myOldFile == null) {
            assert (this.myNewFile != null);
            VirtualFile virtualFile = this.myNewFile;
            if (virtualFile == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/diff/ApkDiffEntry", "getFile"));
            }
            return virtualFile;
        }
        VirtualFile virtualFile = this.myOldFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/diff/ApkDiffEntry", "getFile"));
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/diff/ApkDiffEntry", "getName"));
        }
        return string;
    }

    @Override
    @NotNull
    public String getPath() {
        String string = this.getFile().getPath();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/apk/viewer/diff/ApkDiffEntry", "getPath"));
        }
        return string;
    }

    @Override
    public long getSize() {
        return this.myNewSize - this.myOldSize;
    }

    public long getOldSize() {
        return this.myOldSize;
    }

    public long getNewSize() {
        return this.myNewSize;
    }

    public static long getOldSize(ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getOldSize();
        }
        return apkEntry.getSize();
    }

    public static long getNewSize(ApkEntry apkEntry) {
        if (apkEntry instanceof ApkDiffEntry) {
            return ((ApkDiffEntry)apkEntry).getNewSize();
        }
        return apkEntry.getSize();
    }
}

