/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.assistant.view;

import com.android.tools.idea.assistant.AssistActionHandler;
import com.android.tools.idea.assistant.datamodel.FeatureData;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.android.tools.idea.assistant.datamodel.TutorialData;
import com.android.tools.idea.assistant.view.NavigationButton;
import com.android.tools.idea.assistant.view.StatefulButton;
import com.android.tools.idea.assistant.view.TutorialCard;
import com.android.tools.idea.assistant.view.TutorialChooser;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.structure.services.DeveloperServiceMap;
import com.intellij.openapi.diagnostic.Logger;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class FeaturesPanel
extends JPanel
implements ItemListener,
ActionListener {
    private final List<String> myCardKeys;
    private JPanel myCards;
    private CardLayout myCardLayout;
    @NotNull
    private TutorialBundleData myTutorialBundle;

    public FeaturesPanel(@NotNull TutorialBundleData bundle, DeveloperServiceMap serviceMap) {
        if (bundle == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bundle", "com/android/tools/idea/assistant/view/FeaturesPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myCardKeys = new ArrayList<String>();
        this.myTutorialBundle = bundle;
        this.setBackground(UIUtils.getBackgroundColor());
        this.myCardLayout = new CardLayout();
        this.myCards = new JPanel(this.myCardLayout);
        this.myCards.setOpaque(false);
        this.myCardLayout.setVgap(0);
        this.addCard(new TutorialChooser(this, this.myTutorialBundle), "chooser");
        for (FeatureData featureData : this.myTutorialBundle.getFeatures()) {
            DeveloperServiceMap.DeveloperServiceList services = serviceMap.get(featureData.getServiceId());
            for (TutorialData tutorialData : featureData.getTutorials()) {
                this.addCard(new TutorialCard(this, tutorialData, featureData, bundle.getName(), services), tutorialData.getKey());
            }
        }
        this.add(this.myCards);
    }

    private static Logger getLog() {
        return Logger.getInstance(FeaturesPanel.class);
    }

    private void addCard(Component c, String key) {
        this.myCards.add(c, key);
        this.myCardKeys.add(key);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        CardLayout cl = (CardLayout)this.myCards.getLayout();
        cl.show(this.myCards, (String)e.getItem());
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        if (source instanceof NavigationButton) {
            NavigationButton t = (NavigationButton)e.getSource();
            String key = t.getKey();
            if (!this.myCardKeys.contains(key)) {
                throw new RuntimeException("No views exist with key: " + key);
            }
            this.myCardLayout.show(this.myCards, key);
            FeaturesPanel.getLog().debug("Received request to navigate to view with key: " + key);
        } else if (source instanceof StatefulButton.ActionButton) {
            StatefulButton.ActionButton a = (StatefulButton.ActionButton)e.getSource();
            String actionId = a.getKey();
            AssistActionHandler handler = null;
            for (AssistActionHandler actionHandler : (AssistActionHandler[])AssistActionHandler.EP_NAME.getExtensions()) {
                if (!actionHandler.getId().equals(actionId)) continue;
                handler = actionHandler;
                break;
            }
            if (handler == null) {
                throw new IllegalArgumentException("Unhandled action, no handler found for key \"" + actionId + "\".");
            }
            DeveloperServiceMap.DeveloperServiceList services = a.getDeveloperServices();
            if (services == null) {
                throw new RuntimeException("Unable to find a service to to complete the requested action.");
            }
            handler.handleAction(a.getActionArgument(), services);
            a.updateState();
        } else {
            throw new RuntimeException("Unhandled action, \"" + e.getActionCommand() + "\".");
        }
    }
}

