/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.controllers;

import com.android.tools.idea.editors.gfxtrace.GfxTraceEditor;
import com.android.tools.idea.editors.gfxtrace.GfxTraceUtil;
import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.actions.AtomComboAction;
import com.android.tools.idea.editors.gfxtrace.controllers.ImageCellController;
import com.android.tools.idea.editors.gfxtrace.controllers.ImagePanelController;
import com.android.tools.idea.editors.gfxtrace.models.AtomStream;
import com.android.tools.idea.editors.gfxtrace.renderers.ImageCellRenderer;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.ResourceInfo;
import com.android.tools.idea.editors.gfxtrace.service.Resources;
import com.android.tools.idea.editors.gfxtrace.service.ServiceClient;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Cubemap;
import com.android.tools.idea.editors.gfxtrace.service.gfxapi.Texture2D;
import com.android.tools.idea.editors.gfxtrace.service.image.FetchedImage;
import com.android.tools.idea.editors.gfxtrace.service.image.Format;
import com.android.tools.idea.editors.gfxtrace.service.image.ImageInfo;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomRangePath;
import com.android.tools.idea.editors.gfxtrace.service.path.CapturePath;
import com.android.tools.idea.editors.gfxtrace.service.path.PathListener;
import com.android.tools.idea.editors.gfxtrace.service.path.PathStore;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcePath;
import com.android.tools.idea.editors.gfxtrace.service.path.ResourcesPath;
import com.android.tools.idea.editors.gfxtrace.service.path.ThumbnailPath;
import com.android.tools.idea.editors.gfxtrace.widgets.ImageCellList;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.futures.SingleInFlight;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.ui.JBUI;
import java.awt.Component;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TexturesController
extends ImagePanelController {
    @NotNull
    private AtomComboAction myJumpToAtomComboAction;
    private Object myCurrentResourceId;

    public static JComponent createUI(GfxTraceEditor editor) {
        return new TexturesController((GfxTraceEditor)editor).myPanel;
    }

    public TexturesController(@NotNull GfxTraceEditor editor) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController", "<init>"));
        }
        super(editor, "Select a frame or command");
        this.myPanel.add((Component)new DropDownController((GfxTraceEditor)editor){

            @Override
            public void selected(DropDownController.Data item) {
                TexturesController.this.setEmptyText(this.myList.isEmpty() ? "No textures have been created by this point" : "Select a texture");
                TexturesController.this.setImage(item == null ? null : FetchedImage.load(this.myEditor.getClient(), item.path));
                TexturesController.this.myJumpToAtomComboAction.setAtomIds(item == null ? Collections.emptyList() : Arrays.stream(item.info.getAccesses()).boxed().collect(Collectors.toList()));
                if (item != null && TexturesController.this.myCurrentResourceId != item.info.getID()) {
                    TexturesController.this.myCurrentResourceId = (Object)item.info.getID();
                    String format = item.typeLabel;
                    Integer size = null;
                    if (item.imageInfo != null) {
                        size = item.imageInfo.getWidth() * item.imageInfo.getHeight();
                        format = format + "/" + item.imageInfo.getFormat().toString();
                    }
                    GfxTraceUtil.trackEvent("gfxTraceTextureViewed", format, size);
                }
            }
        }.myList, "North");
        DefaultActionGroup toolbar = new DefaultActionGroup();
        this.myJumpToAtomComboAction = new AtomComboAction(editor);
        this.initToolbar(toolbar, true);
        toolbar.add((AnAction)this.myJumpToAtomComboAction);
    }

    @Override
    public void notifyPath(PathListener.PathEvent event) {
    }

    private static abstract class DropDownController
    extends ImageCellController<Data>
    implements AtomStream.Listener {
        private static final Dimension CONTROL_SIZE = JBUI.size((int)100, (int)50);
        private static final Dimension REQUEST_SIZE = JBUI.size((int)100, (int)100);
        @NotNull
        private static final Logger LOG = Logger.getInstance(TexturesController.class);
        @NotNull
        private final PathStore<ResourcesPath> myResourcesPath;
        private Resources myResources;

        private DropDownController(@NotNull GfxTraceEditor editor) {
            if (editor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController", "<init>"));
            }
            super(editor);
            this.myResourcesPath = new PathStore();
            editor.getAtomStream().addListener(this);
            this.usingComboBoxWidget(CONTROL_SIZE);
            ImageCellRenderer renderer = (ImageCellRenderer)this.myList.getRenderer();
            renderer.setLayout(ImageCellRenderer.Layout.LEFT_TO_RIGHT);
            renderer.setFlipImage(true);
            renderer.setNoItemText("<Click to select texture>");
        }

        @Override
        public void loadCell(Data cell, Runnable onLoad) {
            ServiceClient client = this.myEditor.getClient();
            ThumbnailPath path = cell.path.thumbnail(REQUEST_SIZE, Format.RGBA);
            this.loadCellImage(cell, client, path, onLoad);
            this.loadCellMetadata(cell);
        }

        private void loadCellMetadata(final Data cell) {
            Rpc.listen(this.myEditor.getClient().get(cell.path), (Logger)LOG, (FutureController)cell.extraController, (Rpc.Callback)new UiErrorCallback<Object, Object, String>(){

                @Override
                protected UiErrorCallback.ResultOrError<Object, String> onRpcThread(Rpc.Result<Object> result) throws RpcException, ExecutionException {
                    try {
                        return this.success(result.get());
                    }
                    catch (ErrDataUnavailable e) {
                        return this.error(e.getMessage());
                    }
                }

                @Override
                protected void onUiThreadSuccess(Object resource) {
                    ImageInfo base = null;
                    int mipmapLevels = -1;
                    if (resource instanceof Texture2D) {
                        Texture2D texture = (Texture2D)resource;
                        base = texture.getLevels()[0];
                        mipmapLevels = texture.getLevels().length;
                    } else if (resource instanceof Cubemap) {
                        Cubemap texture = (Cubemap)resource;
                        base = texture.getLevels()[0].getNegativeZ();
                        mipmapLevels = texture.getLevels().length;
                    }
                    if (base != null) {
                        cell.imageInfo = base;
                        cell.extraLabel = (mipmapLevels > 1 ? " - " + mipmapLevels + " mip levels" : "") + " - Modified " + cell.info.getAccesses().length + " times";
                    } else {
                        cell.extraLabel = "Unknown texture type: " + resource.getClass().getName();
                    }
                    myList.repaint();
                }

                @Override
                protected void onUiThreadError(String error) {
                    cell.extraLabel = error;
                    myList.repaint();
                }
            });
        }

        protected void update(boolean resourcesChanged) {
            if (this.myEditor.getAtomStream().getSelectedAtomsPath() != null && this.myResources != null) {
                ArrayList<Data> cells = new ArrayList<Data>();
                this.addTextures(cells, this.myResources.getTextures1D(), "1D");
                this.addTextures(cells, this.myResources.getTextures2D(), "2D");
                this.addTextures(cells, this.myResources.getTextures3D(), "3D");
                this.addTextures(cells, this.myResources.getCubemaps(), "Cubemap");
                int selectedIndex = this.myList.getSelectedItem();
                this.myList.setData(cells);
                if (!resourcesChanged && selectedIndex >= 0 && selectedIndex < cells.size()) {
                    this.myList.selectItem(selectedIndex, false);
                    this.selected(cells.get(selectedIndex));
                } else {
                    this.myList.selectItem(-1, false);
                    this.selected(null);
                }
            }
        }

        private void addTextures(List<Data> cells, ResourceInfo[] textures, String typeLabel) {
            AtomPath atomPath = this.myEditor.getAtomStream().getSelectedAtomsPath().getPathToLast();
            for (ResourceInfo info : textures) {
                if (info.getFirstAccess() > atomPath.getIndex()) continue;
                cells.add(new Data(info, typeLabel, atomPath.resourceAfter(info.getID())));
            }
        }

        @Override
        public void notifyPath(PathListener.PathEvent event) {
            CapturePath capturePath = event.findCapturePath();
            if (capturePath == null) {
                return;
            }
            if (this.myResourcesPath.updateIfNotNull(CapturePath.resources(capturePath))) {
                Rpc.listen(this.myEditor.getClient().get(this.myResourcesPath.getPath()), (Logger)LOG, (Rpc.Callback)new UiErrorCallback<Resources, Resources, String>(){

                    @Override
                    protected UiErrorCallback.ResultOrError<Resources, String> onRpcThread(Rpc.Result<Resources> result) throws RpcException, ExecutionException {
                        try {
                            return this.success(result.get());
                        }
                        catch (ErrDataUnavailable e) {
                            return this.error(e.getMessage());
                        }
                    }

                    @Override
                    protected void onUiThreadSuccess(Resources result) {
                        myResources = result;
                        this.update(true);
                    }

                    @Override
                    protected void onUiThreadError(String error) {
                        myResources = null;
                        this.update(true);
                    }
                });
            }
        }

        @Override
        public void onAtomLoadingStart(AtomStream atoms) {
        }

        @Override
        public void onAtomLoadingComplete(AtomStream atoms) {
        }

        @Override
        public void onAtomsSelected(AtomRangePath path) {
            this.update(false);
        }

        public static class Data
        extends ImageCellList.Data {
            @NotNull
            public final SingleInFlight extraController;
            @NotNull
            public final ResourceInfo info;
            @NotNull
            public final ResourcePath path;
            @NotNull
            public final String typeLabel;
            @Nullable
            public ImageInfo imageInfo;
            @Nullable
            public String extraLabel;

            public Data(@NotNull ResourceInfo info, @NotNull String typeLabel, @NotNull ResourcePath path) {
                if (info == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "info", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController$Data", "<init>"));
                }
                if (typeLabel == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "typeLabel", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController$Data", "<init>"));
                }
                if (path == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/android/tools/idea/editors/gfxtrace/controllers/TexturesController$DropDownController$Data", "<init>"));
                }
                super(info.getName());
                this.extraController = new SingleInFlight();
                this.typeLabel = typeLabel;
                this.info = info;
                this.path = path;
            }

            @Override
            public String getLabel() {
                return this.typeLabel + " " + super.getLabel() + (this.imageInfo == null ? "" : " - " + this.imageInfo.getFormat() + " - " + this.imageInfo.getWidth() + "x" + this.imageInfo.getHeight()) + (this.extraLabel == null ? "" : " " + this.extraLabel);
            }
        }
    }
}

