/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.gapi;

import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.editors.gfxtrace.gapi.Version;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.SystemProperties;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class GapiPaths {
    public static final Version REQUIRED_GAPI_VERSION = Version.VERSION_3;
    private static final Map<String, String> ABI_REMAP = ImmutableMap.builder().put((Object)"32-bit (arm)", (Object)"armeabi-v7a").put((Object)"64-bit (arm)", (Object)"arm64-v8a").put((Object)"armeabi", (Object)"armeabi-v7a").build();
    private static final Map<String, String> ARCH_REMAP = ImmutableMap.builder().put((Object)"i386", (Object)"x86").put((Object)"amd64", (Object)"x86_64").build();
    private static final Map<String, String> ABI_TARGET = ImmutableMap.builder().put((Object)"armeabi-v7a", (Object)"android-armv7a").put((Object)"arm64-v8a", (Object)"android-armv8a").put((Object)"x86", (Object)"android-x86").build();
    @NotNull
    private static final String HOST_OS;
    @NotNull
    private static final String HOST_ARCH;
    @NotNull
    private static final String GAPIS_EXECUTABLE_NAME;
    @NotNull
    private static final String GAPIR_EXECUTABLE_NAME;
    @NotNull
    private static final String STRINGS_DIR_NAME = "strings";
    @NotNull
    private static final String GAPII_LIBRARY_NAME = "libgapii.so";
    @NotNull
    private static final String INTERCEPTOR_LIBRARY_NAME = "libinterceptor.so";
    @NotNull
    private static final String PKG_INFO_NAME = "pkginfo.apk";
    @NotNull
    private static final String EXE_EXTENSION;
    @NotNull
    private static final String SDK_PATH = "gapid";
    @NotNull
    private static final String OS_ANDROID = "android";
    @NotNull
    private static final Object myPathLock;
    private static File myBaseDir;
    private static File myGapisPath;
    private static File myGapirPath;
    private static File myStringsPath;
    private static File myPkgInfoPath;

    public static boolean isValid() {
        GapiPaths.findTools();
        return myGapisPath.exists();
    }

    @NotNull
    public static File base() {
        GapiPaths.findTools();
        File file = myBaseDir;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "base"));
        }
        return file;
    }

    @NotNull
    public static File gapis() {
        GapiPaths.findTools();
        File file = myGapisPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "gapis"));
        }
        return file;
    }

    @NotNull
    public static File gapir() {
        GapiPaths.findTools();
        File file = myGapirPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "gapir"));
        }
        return file;
    }

    @NotNull
    public static File strings() {
        GapiPaths.findTools();
        File file = myStringsPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", STRINGS_DIR_NAME));
        }
        return file;
    }

    @NotNull
    private static File findLibrary(@NotNull String libraryName, @NotNull String abi) throws IOException {
        if (libraryName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libraryName", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findLibrary"));
        }
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findLibrary"));
        }
        GapiPaths.findTools();
        String remappedAbi = GapiPaths.remap(ABI_REMAP, abi);
        File lib = GapiPaths.findPath(OS_ANDROID, remappedAbi, libraryName);
        if (lib.exists()) {
            File file = lib;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findLibrary"));
            }
            return file;
        }
        lib = GapiPaths.findPath(OS_ANDROID, remappedAbi = GapiPaths.remap(ABI_TARGET, remappedAbi), libraryName);
        if (lib.exists()) {
            File file = lib;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findLibrary"));
            }
            return file;
        }
        throw new IOException("Unsupported " + libraryName + " abi '" + abi + "'");
    }

    @NotNull
    public static File findTraceLibrary(@NotNull String abi) throws IOException {
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findTraceLibrary"));
        }
        File file = GapiPaths.findLibrary(GAPII_LIBRARY_NAME, abi);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findTraceLibrary"));
        }
        return file;
    }

    @NotNull
    public static File findInterceptorLibrary(@NotNull String abi) throws IOException {
        if (abi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "abi", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findInterceptorLibrary"));
        }
        File file = GapiPaths.findLibrary(INTERCEPTOR_LIBRARY_NAME, abi);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findInterceptorLibrary"));
        }
        return file;
    }

    @NotNull
    public static File findPkgInfoApk() {
        GapiPaths.findTools();
        File file = myPkgInfoPath;
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPkgInfoApk"));
        }
        return file;
    }

    public static Collection<String> getMissingSdkComponents() {
        LocalPackage gapi;
        if (GapiPaths.isValid() && ((gapi = GapiPaths.getLocalPackage()) == null || REQUIRED_GAPI_VERSION.isCompatible(gapi.getVersion()))) {
            return Collections.emptyList();
        }
        return ImmutableList.of((Object)REQUIRED_GAPI_VERSION.getSdkPackagePath());
    }

    @NotNull
    private static File findPath(@NotNull String os, String abi, @NotNull String binary) {
        File test;
        if (os == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "os", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
        }
        if (binary == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "binary", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
        }
        File osDir = new File(myBaseDir, os);
        if (abi != null) {
            test = new File(new File(osDir, abi), binary);
            if (test.exists()) {
                File file = test;
                if (file == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
                }
                return file;
            }
            test = new File(new File(myBaseDir, abi), binary);
            if (test.exists()) {
                File file = test;
                if (file == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
                }
                return file;
            }
        }
        if ((test = new File(osDir, binary)).exists()) {
            File file = test;
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
            }
            return file;
        }
        File file = new File(myBaseDir, binary);
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/gapi/GapiPaths", "findPath"));
        }
        return file;
    }

    private static String remap(Map<String, String> map, String key) {
        String value = map.get(key);
        if (value == null) {
            value = key;
        }
        return value;
    }

    @Nullable(value="gapi is not installed")
    private static LocalPackage getLocalPackage() {
        AndroidSdkHandler handler = AndroidSdkUtils.tryToChooseSdkHandler();
        return handler.getLocalPackage(REQUIRED_GAPI_VERSION.getSdkPackagePath(), (ProgressIndicator)new StudioLoggerProgressIndicator(GapiPaths.class));
    }

    @Nullable(value="gapi is not installed")
    private static File getSdkPath() {
        LocalPackage info = GapiPaths.getLocalPackage();
        return info == null ? null : info.getLocation();
    }

    private static boolean checkForTools(File dir) {
        if (dir == null) {
            return false;
        }
        myBaseDir = dir;
        myGapisPath = GapiPaths.findPath(HOST_OS, HOST_ARCH, GAPIS_EXECUTABLE_NAME);
        myGapirPath = GapiPaths.findPath(HOST_OS, HOST_ARCH, GAPIR_EXECUTABLE_NAME);
        myPkgInfoPath = GapiPaths.findPath(OS_ANDROID, null, PKG_INFO_NAME);
        myStringsPath = new File(myBaseDir, STRINGS_DIR_NAME);
        return myGapisPath.exists();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void findTools() {
        Object object = myPathLock;
        synchronized (object) {
            String gopath;
            if (myGapisPath != null && myGapisPath.exists()) {
                return;
            }
            if (Boolean.getBoolean("idea.is.internal") && (gopath = System.getenv("GOPATH")) != null && gopath.length() > 0 && GapiPaths.checkForTools(new File(gopath, "bin"))) {
                return;
            }
            if (GapiPaths.checkForTools(GapiPaths.getSdkPath())) {
                return;
            }
            GapiPaths.checkForTools(new File(new File(SystemProperties.getUserHome()), SDK_PATH));
        }
    }

    static {
        if (SystemInfo.isWindows) {
            HOST_OS = "windows";
            EXE_EXTENSION = ".exe";
        } else if (SystemInfo.isMac) {
            HOST_OS = "osx";
            EXE_EXTENSION = "";
        } else if (SystemInfo.isLinux) {
            HOST_OS = "linux";
            EXE_EXTENSION = "";
        } else {
            HOST_OS = SystemInfo.OS_NAME;
            EXE_EXTENSION = "";
        }
        HOST_ARCH = GapiPaths.remap(ARCH_REMAP, SystemInfo.OS_ARCH);
        GAPIS_EXECUTABLE_NAME = "gapis" + EXE_EXTENSION;
        GAPIR_EXECUTABLE_NAME = "gapir" + EXE_EXTENSION;
        myPathLock = new Object();
    }
}

