/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.path;

import com.android.tools.idea.editors.gfxtrace.service.atom.Range;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomPath;
import com.android.tools.idea.editors.gfxtrace.service.path.AtomsPath;
import com.android.tools.idea.editors.gfxtrace.service.path.Path;
import com.android.tools.idea.editors.gfxtrace.service.path.StatePath;
import com.android.tools.rpclib.binary.BinaryClass;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.binary.Decoder;
import com.android.tools.rpclib.binary.Encoder;
import com.android.tools.rpclib.binary.Namespace;
import com.android.tools.rpclib.schema.Entity;
import com.android.tools.rpclib.schema.Field;
import com.android.tools.rpclib.schema.Method;
import com.android.tools.rpclib.schema.Pointer;
import com.android.tools.rpclib.schema.Primitive;
import com.android.tools.rpclib.schema.Struct;
import com.android.tools.rpclib.schema.Type;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public final class AtomRangePath
extends Path {
    private AtomsPath myAtoms;
    private long myFirst;
    private long myCount;
    private static final Entity ENTITY = new Entity("path", "AtomRange", "", "");

    @Override
    public String getSegmentString() {
        return '[' + String.valueOf(this.myFirst) + " - " + String.valueOf(this.myFirst + this.myCount) + ']';
    }

    @Override
    public void appendSegmentToPath(StringBuilder builder) {
        builder.append(this.getSegmentString());
    }

    @Override
    public AtomsPath getParent() {
        return this.myAtoms;
    }

    public long getLast() {
        return this.myFirst + this.myCount - 1L;
    }

    public AtomPath getPathToFirst() {
        return this.myAtoms.index(this.getFirst());
    }

    public AtomPath getPathToLast() {
        return this.myAtoms.index(this.getLast());
    }

    public Range getRange() {
        return new Range().setStart(this.myFirst).setEnd(this.myFirst + this.myCount);
    }

    public StatePath stateAfterLast() {
        return this.getPathToLast().stateAfter();
    }

    public static StatePath stateAfterLast(AtomRangePath atomPath) {
        return atomPath == null ? null : atomPath.stateAfterLast();
    }

    public AtomsPath getAtoms() {
        return this.myAtoms;
    }

    public AtomRangePath setAtoms(AtomsPath v) {
        this.myAtoms = v;
        return this;
    }

    public long getFirst() {
        return this.myFirst;
    }

    public AtomRangePath setFirst(long v) {
        this.myFirst = v;
        return this;
    }

    public long getCount() {
        return this.myCount;
    }

    public AtomRangePath setCount(long v) {
        this.myCount = v;
        return this;
    }

    @NotNull
    public BinaryClass klass() {
        Klass klass = Klass.INSTANCE;
        if (klass == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/AtomRangePath", "klass"));
        }
        return klass;
    }

    public static void register() {
    }

    static {
        ENTITY.setFields(new Field[]{new Field("Atoms", (Type)new Pointer((Type)new Struct(AtomsPath.Klass.INSTANCE.entity()))), new Field("First", (Type)new Primitive("uint64", Method.Uint64)), new Field("Count", (Type)new Primitive("uint64", Method.Uint64))});
        Namespace.register((BinaryClass)Klass.INSTANCE);
    }

    public static enum Klass implements BinaryClass
    {
        INSTANCE;


        @NotNull
        public Entity entity() {
            Entity entity = ENTITY;
            if (entity == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/AtomRangePath$Klass", "entity"));
            }
            return entity;
        }

        @NotNull
        public BinaryObject create() {
            AtomRangePath atomRangePath = new AtomRangePath();
            if (atomRangePath == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/path/AtomRangePath$Klass", "create"));
            }
            return atomRangePath;
        }

        public void encode(@NotNull Encoder e, BinaryObject obj) throws IOException {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/service/path/AtomRangePath$Klass", "encode"));
            }
            AtomRangePath o = (AtomRangePath)obj;
            e.object((BinaryObject)o.myAtoms);
            e.uint64(o.myFirst);
            e.uint64(o.myCount);
        }

        public void decode(@NotNull Decoder d, BinaryObject obj) throws IOException {
            if (d == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "d", "com/android/tools/idea/editors/gfxtrace/service/path/AtomRangePath$Klass", "decode"));
            }
            AtomRangePath o = (AtomRangePath)obj;
            o.myAtoms = (AtomsPath)d.object();
            o.myFirst = d.uint64();
            o.myCount = d.uint64();
        }
    }
}

