/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.service.snippets;

import com.android.tools.idea.editors.gfxtrace.service.atom.Atom;
import com.android.tools.idea.editors.gfxtrace.service.snippets.KindredSnippets;
import com.android.tools.idea.editors.gfxtrace.service.snippets.Pathway;
import com.android.tools.rpclib.binary.BinaryObject;
import com.android.tools.rpclib.schema.Dynamic;
import com.android.tools.rpclib.schema.Field;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class SnippetObject {
    private final Object myObject;
    private final Pathway myPath;
    private final KindredSnippets[] mySnippets;

    public SnippetObject(Object obj, Pathway path, KindredSnippets[] snippets) {
        this.myObject = obj;
        this.myPath = path;
        this.mySnippets = snippets;
    }

    public String toString() {
        return this.myObject == null ? "null" : this.myObject.toString();
    }

    public Pathway getPath() {
        return this.myPath;
    }

    public Object getObject() {
        return this.myObject;
    }

    public boolean isEmpty() {
        if (this.mySnippets.length == 0) {
            return true;
        }
        for (KindredSnippets snip : this.mySnippets) {
            Pathway path = snip.getPath();
            if (!this.myPath.isPrefix(path)) continue;
            return false;
        }
        return true;
    }

    public KindredSnippets[] getSnippets() {
        ArrayList<KindredSnippets> snippets = null;
        for (KindredSnippets snip : this.mySnippets) {
            Pathway path = snip.getPath();
            if (!path.equals(this.myPath)) continue;
            snippets = KindredSnippets.append(snippets, snip);
        }
        return KindredSnippets.toArray(snippets);
    }

    public boolean isRoot() {
        return this.myPath == null && this.mySnippets != null;
    }

    public boolean isSymbol() {
        return this.myPath == null && this.mySnippets == null && this.myObject != null && this.myObject.getClass() == String.class;
    }

    public boolean isNull() {
        return this.myObject == null;
    }

    public boolean isAtom() {
        return this.myObject instanceof Atom;
    }

    public boolean isPrimitive() {
        return !this.isBinaryObject() && !this.isCollection() && !this.isSymbol() && !this.isNull();
    }

    public boolean isBinaryObject() {
        return this.myObject instanceof BinaryObject;
    }

    public boolean isCollection() {
        return this.myObject instanceof Map || this.myObject instanceof Object[] || this.myObject instanceof byte[];
    }

    private static Object longify(Object value) {
        return value instanceof Integer ? Long.valueOf(((Integer)value).longValue()) : value;
    }

    public static SnippetObject symbol(Object symbol) {
        return new SnippetObject(SnippetObject.longify(symbol), null, null);
    }

    public SnippetObject key(Map.Entry<Object, Object> e) {
        return new SnippetObject(SnippetObject.longify(e.getKey()), this.myPath.key(), this.mySnippets);
    }

    public SnippetObject elem(Map.Entry<Object, Object> e) {
        return new SnippetObject(e.getValue(), this.myPath.elem(), this.mySnippets);
    }

    public SnippetObject elem(Object object) {
        return new SnippetObject(object, this.myPath.elem(), this.mySnippets);
    }

    public SnippetObject field(Dynamic obj, int fieldIndex) {
        Field info = obj.getFieldInfo(fieldIndex);
        String name = info.getDeclared();
        Pathway path = this.myPath == null ? Pathway.global(name) : this.myPath.field(name);
        return new SnippetObject(obj.getFieldValue(fieldIndex), path, this.mySnippets);
    }

    private static String lowerCaseFirstCharacter(String str) {
        if (str.length() == 0) {
            return str;
        }
        return Character.toLowerCase(str.charAt(0)) + str.substring(1);
    }

    @NotNull
    public static SnippetObject param(@NotNull Atom atom, int paramIndex) {
        if (atom == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "atom", "com/android/tools/idea/editors/gfxtrace/service/snippets/SnippetObject", "param"));
        }
        KindredSnippets[] snippets = KindredSnippets.fromMetadata(atom.unwrap().klass().entity().getMetadata());
        Field info = atom.getFieldInfo(paramIndex);
        String name = SnippetObject.lowerCaseFirstCharacter(info.getDeclared());
        SnippetObject snippetObject = new SnippetObject(atom.getFieldValue(paramIndex), Pathway.param(atom.getName(), name), snippets);
        if (snippetObject == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/gfxtrace/service/snippets/SnippetObject", "param"));
        }
        return snippetObject;
    }

    public static SnippetObject root(Dynamic obj, KindredSnippets[] snippets) {
        return new SnippetObject(obj, null, snippets);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnippetObject that = (SnippetObject)o;
        return !(this.myObject != null ? !this.myObject.equals(that.myObject) : that.myObject != null);
    }

    public int hashCode() {
        return this.myObject != null ? this.myObject.hashCode() : 0;
    }
}

