/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer;

import com.android.tools.idea.editors.gfxtrace.viewer.gl.Shader;
import com.android.utils.Pair;
import com.google.common.base.Charsets;
import com.google.common.io.LineProcessor;
import com.google.common.io.Resources;
import com.intellij.openapi.diagnostic.Logger;
import com.jogamp.opengl.GL2ES2;
import com.jogamp.opengl.GLContext;
import com.jogamp.opengl.util.glsl.ShaderCode;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.Charset;

public class ShaderSource {
    private static final Logger LOG = Logger.getInstance(ShaderSource.class);

    private ShaderSource() {
    }

    public static Shader loadShader(GL2ES2 gl, String name) {
        return ShaderSource.loadShader(gl, Resources.getResource(ShaderSource.class, (String)("shaders/" + name + ".glsl")));
    }

    public static Shader loadShader(final GL2ES2 gl, URL resource) {
        try {
            Pair source = (Pair)Resources.readLines((URL)resource, (Charset)Charsets.US_ASCII, (LineProcessor)new LineProcessor<Pair<String, String>>(){
                private static final int MODE_COMMON = 0;
                private static final int MODE_VERTEX = 1;
                private static final int MODE_FRAGMENT = 2;
                private static final String VERTEX_130_PREAMBLE = "#define attribute in\n#define varying out\n";
                private static final String FRAGMENT_130_PREAMBLE = "#define varying in\nout vec4 mgl_FragColor;\n#define gl_FragColor mgl_FragColor\n#define texture2D texture\n";
                private final StringBuilder vertexSource = new StringBuilder();
                private final StringBuilder fragmentSource = new StringBuilder();
                private int mode;
                {
                    this.addPreamble();
                    this.mode = 0;
                }

                public boolean processLine(String line) throws IOException {
                    if ("//! COMMON".equals(line = line.trim())) {
                        this.mode = 0;
                    } else if ("//! VERTEX".equals(line)) {
                        this.mode = 1;
                    } else if ("//! FRAGMENT".equals(line)) {
                        this.mode = 2;
                    } else if (!line.startsWith("//")) {
                        switch (this.mode) {
                            case 0: {
                                this.vertexSource.append(line).append('\n');
                                this.fragmentSource.append(line).append('\n');
                                break;
                            }
                            case 1: {
                                this.vertexSource.append(line).append('\n');
                                break;
                            }
                            case 2: {
                                this.fragmentSource.append(line).append('\n');
                            }
                        }
                    }
                    return true;
                }

                private void addPreamble() {
                    String precision;
                    String version = gl.getContext().getGLSLVersionString();
                    String string = precision = ShaderCode.requiresDefaultPrecision((GL2ES2)gl) ? "precision mediump float;\n" : "";
                    if (gl.getContext().getGLSLVersionNumber().compareTo(GLContext.Version1_30) >= 0) {
                        this.vertexSource.append(version).append(precision).append(VERTEX_130_PREAMBLE);
                        this.fragmentSource.append(version).append(precision).append(FRAGMENT_130_PREAMBLE);
                    }
                }

                public Pair<String, String> getResult() {
                    return Pair.of((Object)this.vertexSource.toString(), (Object)this.fragmentSource.toString());
                }
            });
            Shader shader = new Shader(gl);
            if (!shader.link((String)source.getFirst(), (String)source.getSecond())) {
                shader.delete();
                shader = null;
            }
            return shader;
        }
        catch (IOException e) {
            LOG.warn("Failed to load shader source", (Throwable)e);
            return null;
        }
    }
}

