/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.camera;

import com.android.tools.idea.editors.gfxtrace.viewer.camera.Emitter;
import com.android.tools.idea.editors.gfxtrace.viewer.vec.VecD;

public class RayCaster {
    private static final int MAX_LINEAR_STEPS = 128;
    private static final int MAX_BINARY_STEPS = 32;
    private static final double PRECISION = 1.0E-5;
    private static final double MIN_STEP = 0.05;
    private final Emitter myEmitter;

    public RayCaster(Emitter emitter) {
        this.myEmitter = emitter;
    }

    public VecD getIntersection(VecD src, VecD direction) {
        double potential = this.myEmitter.getPotentialAt(src);
        boolean inside = potential < 0.0;
        VecD prev = src;
        int i = 0;
        while (true) {
            double absPotential;
            if ((absPotential = Math.abs(potential)) < 1.0E-5) {
                return src;
            }
            if (potential < 0.0 != inside) break;
            if (absPotential < 0.05) {
                potential = Math.signum(potential) * 0.05;
            }
            prev = src;
            src = src.addScaled(direction, potential);
            potential = this.myEmitter.getPotentialAt(src);
            if (i >= 128) {
                return null;
            }
            ++i;
        }
        return inside ? this.binarySearch(prev, src) : this.binarySearch(src, prev);
    }

    private VecD binarySearch(VecD start, VecD end) {
        for (int i = 0; i < 32; ++i) {
            VecD mid = start.add(end).scale(0.5);
            double potential = this.myEmitter.getPotentialAt(mid);
            if (Math.abs(potential) < 1.0E-5) {
                return mid;
            }
            if (potential < 0.0) {
                start = mid;
                continue;
            }
            end = mid;
        }
        return null;
    }
}

