/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.viewer.gl;

import com.android.tools.idea.editors.gfxtrace.viewer.gl.Util;
import com.jogamp.opengl.GL;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class Buffer {
    private final GL myGl;
    private final int myTarget;
    private final int myHandle;
    private int mySize;

    public Buffer(GL gl, int target) {
        this.myGl = gl;
        this.myTarget = target;
        this.myHandle = Util.createBuffer(gl);
    }

    public Buffer bind() {
        this.myGl.glBindBuffer(this.myTarget, this.myHandle);
        return this;
    }

    public Buffer loadData(ByteBuffer buffer) {
        return this.loadData(buffer, 35044);
    }

    public Buffer loadData(ByteBuffer buffer, int usage) {
        this.mySize = buffer.remaining();
        this.myGl.glBufferData(this.myTarget, (long)this.mySize, (java.nio.Buffer)buffer, usage);
        return this;
    }

    public int getSize() {
        return this.mySize;
    }

    public void delete() {
        this.myGl.glDeleteBuffers(1, new int[]{this.myHandle}, 0);
    }

    public static ByteBuffer wrap(byte[] data) {
        return ByteBuffer.wrap(data);
    }

    public static ByteBuffer wrap(short[] data) {
        ByteBuffer result = ByteBuffer.allocate(data.length * 2);
        result.order(ByteOrder.nativeOrder());
        result.asShortBuffer().put(data);
        result.rewind();
        return result;
    }

    public static ByteBuffer wrap(int[] data) {
        ByteBuffer result = ByteBuffer.allocate(data.length * 4);
        result.order(ByteOrder.nativeOrder());
        result.asIntBuffer().put(data);
        result.rewind();
        return result;
    }

    public static ByteBuffer wrap(float[] data) {
        ByteBuffer result = ByteBuffer.allocate(data.length * 4);
        result.order(ByteOrder.nativeOrder());
        result.asFloatBuffer().put(data);
        result.rewind();
        return result;
    }
}

