/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.UiErrorCallback;
import com.android.tools.idea.editors.gfxtrace.service.ErrDataUnavailable;
import com.android.tools.idea.editors.gfxtrace.service.image.MultiLevelImage;
import com.android.tools.rpclib.futures.FutureController;
import com.android.tools.rpclib.rpccore.Rpc;
import com.android.tools.rpclib.rpccore.RpcException;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StatusText;
import icons.AndroidIcons;
import icons.ImagesIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Composite;
import java.awt.CompositeContext;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.Arrays;
import java.util.concurrent.ExecutionException;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import sun.awt.image.IntegerComponentRaster;

public class ImagePanel
extends JPanel {
    private static final Logger LOG = Logger.getInstance(ImagePanel.class);
    private static final int ZOOM_AMOUNT = 5;
    private static final int SCROLL_AMOUNT = 15;
    @NotNull
    private final ImageComponent myImage;
    @NotNull
    private final JBLabel myStatus = new JBLabel();

    public ImagePanel() {
        super(new BorderLayout());
        JBScrollPane scrollPane = new JBScrollPane();
        this.myImage = new ImageComponent(scrollPane);
        scrollPane.getVerticalScrollBar().setUnitIncrement(20);
        scrollPane.getHorizontalScrollBar().setUnitIncrement(20);
        scrollPane.setBorder(BorderFactory.createLineBorder(JBColor.border()));
        this.add((Component)scrollPane, "Center");
        this.add((Component)new JPanel(new FlowLayout(0)){
            {
                this.add(ImagePanel.this.myImage.getLevelChooser());
                this.add((Component)ImagePanel.this.myStatus, "South");
            }
        }, "South");
        this.setFocusable(true);
        MouseAdapter mouseHandler = new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                this.update(e.getX(), e.getY());
            }

            @Override
            public void mouseExited(MouseEvent e) {
                ImagePanel.this.myStatus.setText(" ");
            }

            @Override
            public void mouseMoved(MouseEvent e) {
                this.update(e.getX(), e.getY());
            }

            @Override
            public void mouseDragged(MouseEvent e) {
                this.update(e.getX(), e.getY());
            }

            private void update(int x, int y) {
                ImagePanel.this.myImage.getPixel(x, y).formatTo(ImagePanel.this.myStatus);
            }
        };
        scrollPane.getViewport().addMouseListener(mouseHandler);
        scrollPane.getViewport().addMouseMotionListener(mouseHandler);
    }

    public void addToolbarActions(DefaultActionGroup group, boolean enableVerticalFlip) {
        this.myImage.addToolbarActions(group, enableVerticalFlip);
    }

    public void clearImage() {
        this.myImage.clearImage();
    }

    public StatusText getEmptyText() {
        return this.myImage.getEmptyText();
    }

    public void setImageRequestController(FutureController imageRequestController) {
        this.myImage.setImageRequestController(imageRequestController);
    }

    public void setImage(MultiLevelImage image) {
        this.myImage.setImage(image);
    }

    private static class Pixel {
        public static final Pixel OUT_OF_BOUNDS = new Pixel(-1, -1, -1.0f, -1.0f, 0){

            @Override
            public void formatTo(JBLabel label) {
                label.setText(" ");
            }
        };
        public final int x;
        public final int y;
        public final float u;
        public final float v;
        public final int rgba;

        public Pixel(int x, int y, float u, float v, int rgba) {
            this.x = x;
            this.y = y;
            this.u = u;
            this.v = v;
            this.rgba = rgba;
        }

        public void formatTo(JBLabel label) {
            label.setText(String.format("X: %d, Y: %d, U: %05f, V: %05f, ARGB: %08x", this.x, this.y, Float.valueOf(this.u), Float.valueOf(this.v), this.rgba));
        }
    }

    private static final class ImageComponent
    extends JComponent {
        private static final double ZOOM_FIT = Double.POSITIVE_INFINITY;
        private static final double MAX_ZOOM_FACTOR = 8.0;
        private static final double MIN_ZOOM_WIDTH = 100.0;
        private static final int BORDER_SIZE = JBUI.scale((int)2);
        private static final Border BORDER = new LineBorder(JBColor.border(), BORDER_SIZE);
        private static final Paint CHECKER_PAINT = new CheckerboardPaint();
        private static final int CHANNEL_RED = 0;
        private static final int CHANNEL_GREEN = 1;
        private static final int CHANNEL_BLUE = 2;
        private static final int CHANNEL_ALPHA = 3;
        private final JViewport parent;
        private final StatusText emptyText;
        private final LevelChooser levelChooser = new LevelChooser();
        private FutureController imageRequestController = FutureController.NULL_CONTROLLER;
        private MultiLevelImage image;
        private BufferedImage level = MultiLevelImage.EMPTY_LEVEL;
        private BufferedImage displayed = null;
        private double zoom;
        private boolean drawCheckerBoard = true;
        private boolean flipped = false;
        private boolean[] channels = new boolean[]{true, true, true, true};

        public ImageComponent(JBScrollPane scrollPane) {
            scrollPane.setViewportView((Component)this);
            this.parent = scrollPane.getViewport();
            this.emptyText = new StatusText(){

                protected boolean isStatusVisible() {
                    return image == MultiLevelImage.EMPTY_IMAGE;
                }
            };
            this.emptyText.attachTo((Component)this.parent);
            this.zoom = Double.POSITIVE_INFINITY;
            this.levelChooser.addListener(new LevelChooser.Listener(){

                @Override
                public void levelChanged(int level) {
                    this.loadLevel(level);
                }
            });
            MouseAdapter mouseHandler = new MouseAdapter(){
                private int lastX;
                private int lastY;

                @Override
                public void mouseWheelMoved(MouseWheelEvent e) {
                    this.zoom(Math.max(-5, Math.min(5, e.getWheelRotation())), e.getPoint());
                }

                @Override
                public void mousePressed(MouseEvent e) {
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    if (this.isPanningButton(e)) {
                        this.setCursor(new Cursor(13));
                    } else {
                        this.zoomToFit();
                    }
                }

                @Override
                public void mouseReleased(MouseEvent e) {
                    this.setCursor(null);
                }

                @Override
                public void mouseDragged(MouseEvent e) {
                    int dx = this.lastX - e.getX();
                    int dy = this.lastY - e.getY();
                    this.lastX = e.getX();
                    this.lastY = e.getY();
                    if (this.isPanningButton(e)) {
                        this.scrollBy(dx, dy);
                    }
                }

                private boolean isPanningButton(MouseEvent e) {
                    return (e.getModifiersEx() & 0xC00) != 0;
                }
            };
            this.parent.addMouseListener(mouseHandler);
            this.parent.addMouseWheelListener(mouseHandler);
            this.parent.addMouseMotionListener(mouseHandler);
            this.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    switch (e.getKeyCode()) {
                        case 38: 
                        case 75: {
                            this.scrollBy(0, -15);
                            break;
                        }
                        case 40: 
                        case 74: {
                            this.scrollBy(0, 15);
                            break;
                        }
                        case 37: 
                        case 72: {
                            this.scrollBy(-15, 0);
                            break;
                        }
                        case 39: 
                        case 76: {
                            this.scrollBy(15, 0);
                            break;
                        }
                        case 107: 
                        case 521: {
                            this.zoom(-5, this.getCenterPoint());
                            break;
                        }
                        case 45: 
                        case 109: {
                            this.zoom(5, this.getCenterPoint());
                            break;
                        }
                        case 61: {
                            if ((e.getModifiersEx() & 0x40) != 0) {
                                this.zoom(-5, this.getCenterPoint());
                                break;
                            }
                            this.zoomToFit();
                        }
                    }
                }
            });
        }

        public StatusText getEmptyText() {
            return this.emptyText;
        }

        public void setImageRequestController(FutureController imageRequestController) {
            this.imageRequestController = imageRequestController;
        }

        public void clearImage() {
            this.image = MultiLevelImage.EMPTY_IMAGE;
            this.level = MultiLevelImage.EMPTY_LEVEL;
            this.levelChooser.update(1);
            this.revalidate();
            this.repaint();
        }

        public void setImage(MultiLevelImage image) {
            if (this.image == MultiLevelImage.EMPTY_IMAGE) {
                this.zoomToFit();
            }
            this.image = image == null ? MultiLevelImage.EMPTY_IMAGE : image;
            this.level = MultiLevelImage.EMPTY_LEVEL;
            this.displayed = null;
            if (!this.levelChooser.update(this.image.getLevelCount())) {
                this.loadLevel(this.levelChooser.getLevel());
            }
            this.revalidate();
            this.repaint();
        }

        public void addToolbarActions(DefaultActionGroup group, boolean enableVerticalFlip) {
            group.add(new AnAction("Zoom to Fit", "Fit the image to the panel", AndroidIcons.ZoomFit){

                public void actionPerformed(AnActionEvent e) {
                    this.zoomToFit();
                }
            });
            group.add(new AnAction("Actual Size", "Display the image at its actual size", AndroidIcons.ZoomActual){

                public void actionPerformed(AnActionEvent e) {
                    this.zoomToActual();
                }
            });
            group.add(new AnAction("Zoom In", "Zoom In", AndroidIcons.ZoomIn){

                public void actionPerformed(AnActionEvent e) {
                    this.zoom(-5, this.getCenterPoint());
                }
            });
            group.add(new AnAction("Zoom Out", "Zoom Out", AndroidIcons.ZoomOut){

                public void actionPerformed(AnActionEvent e) {
                    this.zoom(5, this.getCenterPoint());
                }
            });
            group.add((AnAction)new Separator());
            group.add(new AnAction("Color Channels", "Select color channels to show", AndroidIcons.GfxTrace.ColorChannels){

                public void actionPerformed(AnActionEvent e) {
                    JPanel contents = new JPanel();
                    contents.add((Component)((Object)new ChannelCheckbox("Red", 0)));
                    contents.add((Component)((Object)new ChannelCheckbox("Green", 1)));
                    contents.add((Component)((Object)new ChannelCheckbox("Blue", 2)));
                    contents.add((Component)((Object)new ChannelCheckbox("Alpha", 3)));
                    JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder((JComponent)contents, (JComponent)contents).setCancelOnClickOutside(true).setResizable(false).setMovable(false).createPopup();
                    Component source = e.getInputEvent().getComponent();
                    popup.setMinimumSize(new Dimension(0, source.getHeight()));
                    popup.show(new RelativePoint(source, new Point(source.getWidth(), 0)));
                }

                class ChannelCheckbox
                extends JBCheckBox {
                    public ChannelCheckbox(String text, int index) {
                        super(text, channels[index]);
                        this.addActionListener(e -> this.setChannelEnabled(index, this.isSelected()));
                    }
                }
            });
            group.add((AnAction)new ToggleAction("Show Checkerboard", "Toggle the checkerboard background", ImagesIcons.ToggleTransparencyChessboard){

                public boolean isSelected(AnActionEvent e) {
                    return drawCheckerBoard;
                }

                public void setSelected(AnActionEvent e, boolean state) {
                    drawCheckerBoard = state;
                    this.repaint();
                }

                public void update(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/editors/gfxtrace/widgets/ImagePanel$ImageComponent$10", "update"));
                    }
                    super.update(e);
                    Presentation presentation = e.getPresentation();
                    presentation.setEnabled(channels[3]);
                }
            });
            if (enableVerticalFlip) {
                this.flipped = true;
                group.add((AnAction)new ToggleAction("Flip Vertically", "Flip The image vertically", AndroidIcons.GfxTrace.FlipVertically){

                    public boolean isSelected(AnActionEvent e) {
                        return flipped;
                    }

                    public void setSelected(AnActionEvent e, boolean state) {
                        flipped = state;
                        this.repaint();
                    }
                });
            }
        }

        public LevelChooser getLevelChooser() {
            return this.levelChooser;
        }

        public Pixel getPixel(int x, int y) {
            if (this.image == MultiLevelImage.EMPTY_IMAGE || this.level == MultiLevelImage.EMPTY_LEVEL) {
                return Pixel.OUT_OF_BOUNDS;
            }
            double scale = this.zoom == Double.POSITIVE_INFINITY ? this.getFitRatio() : this.zoom;
            int w = (int)((double)this.level.getWidth(this) * scale);
            int h = (int)((double)this.level.getHeight(this) * scale);
            Point pos = this.parent.getViewPosition();
            pos.translate(x - (this.getWidth() - w) / 2, y - (this.getHeight() - h) / 2);
            if (pos.x < 0 || pos.x >= w || pos.y < 0 || pos.y >= h) {
                return Pixel.OUT_OF_BOUNDS;
            }
            int pixelX = (int)((double)pos.x / scale);
            int pixelY = (int)((double)pos.y / scale);
            float u = ((float)pos.x + 0.5f) / (float)w;
            float v = ((float)pos.y + 0.5f) / (float)h;
            return new Pixel(pixelX, this.level.getHeight() - pixelY - 1, u, this.flipped ? v : 1.0f - v, this.level.getRGB(pixelX, pixelY));
        }

        @Override
        public Dimension getPreferredSize() {
            return this.zoom == Double.POSITIVE_INFINITY ? new Dimension(this.parent.getWidth(), this.parent.getHeight()) : new Dimension((int)(this.zoom * (double)this.level.getWidth(this)) + 2 * BORDER_SIZE, (int)(this.zoom * (double)this.level.getHeight(this)) + 2 * BORDER_SIZE);
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (this.image == MultiLevelImage.EMPTY_IMAGE || this.level == MultiLevelImage.EMPTY_LEVEL) {
                this.emptyText.paint((Component)this.parent, g);
                return;
            }
            double scale = this.zoom == Double.POSITIVE_INFINITY ? this.getFitRatio() : this.zoom;
            int w = (int)((double)this.level.getWidth(this) * scale);
            int h = (int)((double)this.level.getHeight(this) * scale);
            int x = (this.getWidth() - w) / 2;
            int y = (this.getHeight() - h) / 2;
            if (this.drawCheckerBoard && this.channels[3]) {
                ((Graphics2D)g).setPaint(CHECKER_PAINT);
                g.fillRect(x, y, w, h);
            }
            AffineTransform transform = ((Graphics2D)g).getTransform();
            if (this.flipped) {
                ((Graphics2D)g).transform(new AffineTransform(1.0f, 0.0f, 0.0f, -1.0f, 0.0f, this.getHeight() - 1));
            }
            if (this.displayed == null) {
                Composite composite = null;
                if (this.channels[0] && this.channels[1] && this.channels[2] && this.channels[3]) {
                    this.displayed = this.level;
                } else {
                    composite = (srcColorModel, dstColorModel, hints) -> new CompositeContext(){

                        @Override
                        public void dispose() {
                        }

                        @Override
                        public void compose(Raster srcRaster, Raster dstIn, WritableRaster dstOut) {
                            byte[] dst = ((DataBufferByte)dstOut.getDataBuffer()).getData();
                            byte[] src = ((DataBufferByte)srcRaster.getDataBuffer()).getData();
                            for (int i = 0; i < dst.length; i += 4) {
                                dst[i + 0] = channels[3] ? src[i + 0] : -1;
                                dst[i + 1] = channels[2] ? src[i + 1] : (byte)0;
                                dst[i + 2] = channels[1] ? src[i + 2] : (byte)0;
                                dst[i + 3] = channels[0] ? src[i + 3] : (byte)0;
                            }
                        }
                    };
                }
                if (composite != null) {
                    this.displayed = new BufferedImage(this.level.getWidth(this), this.level.getHeight(this), 6);
                    Graphics2D displayedG = this.displayed.createGraphics();
                    displayedG.setComposite(composite);
                    displayedG.drawImage((Image)this.level, 0, 0, this);
                    displayedG.dispose();
                }
            }
            g.drawImage(this.displayed, x, y, w, h, this);
            ((Graphics2D)g).setTransform(transform);
            BORDER.paintBorder(this, g, x - BORDER_SIZE, y - BORDER_SIZE, w + 2 * BORDER_SIZE, h + 2 * BORDER_SIZE);
        }

        private void loadLevel(int index) {
            index = Math.min(this.image.getLevelCount() - 1, index);
            Rpc.listen(this.image.getLevel(index), (Logger)LOG, (FutureController)this.imageRequestController, (Rpc.Callback)new UiErrorCallback<BufferedImage, BufferedImage, String>(){

                @Override
                protected UiErrorCallback.ResultOrError<BufferedImage, String> onRpcThread(Rpc.Result<BufferedImage> result) throws RpcException, ExecutionException {
                    try {
                        return this.success(result.get());
                    }
                    catch (ErrDataUnavailable e) {
                        return this.error(e.getMessage());
                    }
                }

                @Override
                protected void onUiThreadSuccess(BufferedImage image) {
                    this.updateLevel(image);
                }

                @Override
                protected void onUiThreadError(String message) {
                    this.clearImage();
                    this.getEmptyText().setText(message);
                }
            });
        }

        protected void updateLevel(BufferedImage level) {
            if (this.level == MultiLevelImage.EMPTY_LEVEL) {
                this.zoomToFit();
            }
            this.level = level == null ? MultiLevelImage.EMPTY_LEVEL : level;
            this.displayed = null;
            this.revalidate();
            this.repaint();
        }

        private void setChannelEnabled(int channel, boolean enabled) {
            if (this.channels[channel] != enabled) {
                this.channels[channel] = enabled;
                this.displayed = null;
                this.repaint();
            }
        }

        private void scrollBy(int dx, int dy) {
            if (dx == 0 && dy == 0) {
                this.revalidate();
                this.repaint();
            } else {
                this.parent.scrollRectToVisible(new Rectangle(new Point(dx, dy), this.parent.getExtentSize()));
            }
        }

        private Point getCenterPoint() {
            return new Point(this.parent.getWidth() / 2, this.parent.getHeight() / 2);
        }

        private void zoom(int amount, Point cursor) {
            Dimension oldSize = this.getPreferredSize();
            oldSize.setSize(Math.max(this.parent.getWidth(), oldSize.width), Math.max(this.parent.getHeight(), oldSize.height));
            if (this.zoom == Double.POSITIVE_INFINITY) {
                this.zoom = this.getFitRatio();
            }
            int delta = Math.min(Math.max(amount, -5), 5);
            this.zoom = Math.min(this.getMaxZoom(), Math.max(this.getMinZoom(), this.zoom * (1.0 - 0.05 * (double)delta)));
            this.invalidate();
            Dimension newSize = this.getPreferredSize();
            newSize.setSize(Math.max(this.parent.getWidth(), newSize.width), Math.max(this.parent.getHeight(), newSize.height));
            Point pos = this.parent.getViewPosition();
            pos.translate(cursor.x, cursor.y);
            this.scrollBy(pos.x * newSize.width / oldSize.width - pos.x, pos.y * newSize.height / oldSize.height - pos.y);
        }

        private void zoomToFit() {
            this.zoom = Double.POSITIVE_INFINITY;
            this.revalidate();
            this.repaint();
        }

        private void zoomToActual() {
            this.zoom = 1.0;
            this.revalidate();
            this.repaint();
        }

        private double getFitRatio() {
            return Math.min((double)(this.getWidth() - 2 * BORDER_SIZE) / (double)this.level.getWidth(this), (double)(this.getHeight() - 2 * BORDER_SIZE) / (double)this.level.getHeight(this));
        }

        private double getMinZoom() {
            return Math.min(1.0, Math.min(this.getFitRatio(), Math.min(100.0 / (double)this.level.getWidth(this), 100.0 / (double)this.level.getHeight(this))));
        }

        private double getMaxZoom() {
            return Math.max(8.0, this.getFitRatio());
        }

        private static class LevelChooser
        extends JPanel {
            private final JSlider mySlider = new JSlider();

            public LevelChooser() {
                this.mySlider.setPaintTicks(true);
                this.mySlider.setSnapToTicks(true);
                this.mySlider.setMajorTickSpacing(1);
                this.mySlider.setFocusable(false);
                this.setVisible(false);
                final JBLabel valueLabel = new JBLabel("0");
                this.mySlider.addChangeListener(new ChangeListener(){

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        valueLabel.setText(String.valueOf(mySlider.getValue()));
                    }
                });
                this.add((Component)new JBLabel("Level:"));
                this.add(this.mySlider);
                this.add((Component)valueLabel);
            }

            public boolean update(int numLevels) {
                this.setVisible(numLevels > 1);
                int value = this.mySlider.getValue();
                if (value >= numLevels) {
                    this.mySlider.setValue(numLevels - 1);
                }
                this.mySlider.setMinimum(0);
                this.mySlider.setMaximum(numLevels - 1);
                return value >= numLevels;
            }

            public int getLevel() {
                return this.mySlider.getValue();
            }

            public void addListener(final Listener listener) {
                this.mySlider.addChangeListener(new ChangeListener(){
                    private int value;
                    {
                        this.value = mySlider.getValue();
                    }

                    @Override
                    public void stateChanged(ChangeEvent e) {
                        int newValue = mySlider.getValue();
                        if (newValue != this.value) {
                            this.value = newValue;
                            listener.levelChanged(newValue);
                        }
                    }
                });
            }

            public static interface Listener {
                public void levelChanged(int var1);
            }
        }

        private static class CheckerboardPaint
        implements Paint,
        PaintContext {
            private static final int CHECKER_SIZE = JBUI.scale((int)15);
            private static final int TWO_CHECKER_SIZE = 2 * CHECKER_SIZE;
            private static final int LIGHT_COLOR = -1;
            private static final int DARK_COLOR = -4144960;
            private WritableRaster cachedRaster;
            private int[] cachedEvenRow = new int[0];
            private int[] cachedOddRow = new int[0];

            private CheckerboardPaint() {
            }

            @Override
            public PaintContext createContext(ColorModel cm, Rectangle deviceBounds, Rectangle2D userBounds, AffineTransform xform, RenderingHints hints) {
                return this;
            }

            @Override
            public void dispose() {
                this.cachedRaster = null;
            }

            @Override
            public ColorModel getColorModel() {
                return ColorModel.getRGBdefault();
            }

            @Override
            public Raster getRaster(int x, int y, int w, int h) {
                WritableRaster raster = this.cachedRaster;
                if (raster == null || w > raster.getWidth() || h > raster.getHeight()) {
                    this.cachedRaster = raster = this.getColorModel().createCompatibleWritableRaster(w, h);
                }
                w = raster.getWidth();
                h = raster.getHeight();
                int xOffset = x % TWO_CHECKER_SIZE;
                int yOffset = y % TWO_CHECKER_SIZE;
                int[] evenRow = this.cachedEvenRow;
                int[] oddRow = this.cachedOddRow;
                if (evenRow.length < xOffset + w || oddRow.length < xOffset + w) {
                    evenRow = new int[TWO_CHECKER_SIZE * ((xOffset + w + TWO_CHECKER_SIZE - 1) / TWO_CHECKER_SIZE)];
                    oddRow = new int[evenRow.length];
                    for (int i = 0; i < evenRow.length; i += TWO_CHECKER_SIZE) {
                        Arrays.fill(evenRow, i, i + CHECKER_SIZE, -1);
                        Arrays.fill(evenRow, i + CHECKER_SIZE, i + TWO_CHECKER_SIZE, -4144960);
                        Arrays.fill(oddRow, i, i + CHECKER_SIZE, -4144960);
                        Arrays.fill(oddRow, i + CHECKER_SIZE, i + TWO_CHECKER_SIZE, -1);
                    }
                }
                int[] pixels = ((IntegerComponentRaster)raster).getDataStorage();
                int[][] rows = new int[][]{evenRow, oddRow};
                int curRowPointer = yOffset < CHECKER_SIZE ? 0 : 1;
                int[] curRow = rows[curRowPointer];
                int i = 0;
                int done = 0;
                int tileY = yOffset % CHECKER_SIZE;
                while (i < h) {
                    if (tileY >= CHECKER_SIZE) {
                        tileY = 0;
                        curRowPointer = curRowPointer + 1 & 1;
                        curRow = rows[curRowPointer];
                    }
                    System.arraycopy(curRow, xOffset, pixels, done, w);
                    ++i;
                    ++tileY;
                    done += w;
                }
                return raster;
            }

            @Override
            public int getTransparency() {
                return 1;
            }
        }
    }
}

