/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.gfxtrace.widgets;

import com.android.tools.idea.editors.gfxtrace.renderers.RenderUtils;
import com.android.tools.idea.editors.gfxtrace.widgets.LoadingIndicator;
import com.android.tools.idea.editors.gfxtrace.widgets.Repaintables;
import com.intellij.icons.AllIcons;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nullable;

public class LoadableIcon
extends JComponent
implements Icon {
    private final int myWidth;
    private final int myHeight;
    private BufferedImage myImage;
    private State myState = State.LOADING;
    private Component myRepaintComponent = this;

    public LoadableIcon(int width, int height) {
        this.myWidth = width;
        this.myHeight = height;
        this.setBounds(0, 0, width, height);
    }

    public LoadableIcon withImage(@Nullable(value="image still loading or loading failed") BufferedImage image, boolean loadingFailed) {
        this.myState = loadingFailed ? State.FAILED : (image == null ? State.LOADING : State.LOADED);
        this.myImage = image;
        this.repaint();
        return this;
    }

    public LoadableIcon withRepaintComponent(Component component) {
        this.myRepaintComponent = component;
        return this;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        switch (this.myState) {
            case LOADING: {
                LoadingIndicator.paint(c, g, x, y, this.getWidth(), this.getHeight());
                LoadingIndicator.scheduleForRedraw(Repaintables.forComponent(this.myRepaintComponent));
                break;
            }
            case LOADED: {
                if (this.myImage == null) break;
                RenderUtils.drawImage(c, g, this.myImage, x, y, this.getWidth(), this.getHeight());
                break;
            }
            case FAILED: {
                RenderUtils.drawIcon(c, g, AllIcons.General.Warning, x, y, this.getWidth(), this.getHeight());
            }
        }
    }

    @Override
    public int getIconWidth() {
        return this.getWidth();
    }

    @Override
    public int getIconHeight() {
        return this.getHeight();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myImage != null ? new Dimension(this.myImage.getWidth(), this.myImage.getHeight()) : new Dimension(this.myWidth, this.myHeight);
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.paintIcon(this, g, 0, 0);
    }

    private static enum State {
        LOADING,
        LOADED,
        FAILED;

    }
}

