/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.attributes.variants;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.resources.configuration.VersionQualifier;
import com.android.sdklib.IAndroidTarget;
import com.android.tools.idea.configurations.Configuration;
import com.android.tools.idea.configurations.ConfigurationManager;
import com.android.tools.idea.editors.theme.ThemeEditorContext;
import com.android.tools.idea.editors.theme.attributes.variants.VariantsComboItem;
import com.android.tools.idea.rendering.Locale;
import com.android.tools.idea.rendering.multi.CompatibilityRenderTarget;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import org.jetbrains.annotations.NotNull;

public class VariantItemListener
implements ItemListener {
    private final ThemeEditorContext myContext;

    public VariantItemListener(@NotNull ThemeEditorContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/editors/theme/attributes/variants/VariantItemListener", "<init>"));
        }
        this.myContext = context;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() != 1) {
            return;
        }
        VariantsComboItem item = (VariantsComboItem)e.getItem();
        Configuration oldConfiguration = this.myContext.getConfiguration();
        ConfigurationManager manager = oldConfiguration.getConfigurationManager();
        Configuration newConfiguration = Configuration.create(manager, null, null, item.getRestrictedConfiguration());
        VersionQualifier newVersionQualifier = item.getRestrictedConfiguration().getVersionQualifier();
        if (newVersionQualifier != null) {
            IAndroidTarget realTarget;
            IAndroidTarget iAndroidTarget = realTarget = manager.getHighestApiTarget() != null ? manager.getHighestApiTarget() : manager.getTarget();
            assert (realTarget != null);
            manager.setTarget(new CompatibilityRenderTarget(realTarget, newVersionQualifier.getVersion(), null));
        } else {
            manager.setTarget(null);
        }
        LocaleQualifier newLocaleQualifier = item.getRestrictedConfiguration().getLocaleQualifier();
        manager.setLocale(newLocaleQualifier != null ? Locale.create(newLocaleQualifier) : Locale.ANY);
        oldConfiguration.setDevice(null, false);
        Configuration.copyCompatible(newConfiguration, oldConfiguration);
        oldConfiguration.updated(246);
    }
}

