/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.editors.theme.qualifiers;

import com.android.ide.common.resources.configuration.ResourceQualifier;
import com.intellij.openapi.diagnostic.Logger;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class QualifierUtils {
    private static final Logger LOG = Logger.getInstance(QualifierUtils.class);

    @NotNull
    public static Object getValue(@NotNull ResourceQualifier qualifier) {
        Object object;
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "getValue"));
        }
        try {
            Method getValue = qualifier.getClass().getMethod("getValue", new Class[0]);
            object = getValue.invoke((Object)qualifier, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "getValue"));
        }
        return object;
    }

    @Nullable(value="if there is no getValue method")
    public static Class getValueReturnType(@NotNull Class<? extends ResourceQualifier> resourceQualifierClass) {
        if (resourceQualifierClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resourceQualifierClass", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "getValueReturnType"));
        }
        try {
            return resourceQualifierClass.getMethod("getValue", new Class[0]).getReturnType();
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    @NotNull
    public static ResourceQualifier createNewResourceQualifier(@NotNull Class<? extends ResourceQualifier> qualifierClass, @NotNull Object value) {
        ResourceQualifier resourceQualifier;
        block10: {
            if (qualifierClass == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifierClass", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "createNewResourceQualifier"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "createNewResourceQualifier"));
            }
            Class<?> valueClass = value.getClass();
            if (!valueClass.equals(Integer.class)) break block10;
            Constructor<? extends ResourceQualifier> constructor = qualifierClass.getConstructor(Integer.TYPE);
            ResourceQualifier resourceQualifier2 = constructor.newInstance((int)((Integer)value));
            if (resourceQualifier2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "createNewResourceQualifier"));
            }
            return resourceQualifier2;
        }
        try {
            Constructor<? extends ResourceQualifier> constructor = qualifierClass.getConstructor(value.getClass());
            resourceQualifier = constructor.newInstance(value);
        }
        catch (NoSuchMethodException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InstantiationException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (IllegalAccessException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        catch (InvocationTargetException e) {
            LOG.error((Throwable)e);
            throw new IllegalArgumentException(e);
        }
        if (resourceQualifier == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/editors/theme/qualifiers/QualifierUtils", "createNewResourceQualifier"));
        }
        return resourceQualifier;
    }
}

