/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.GeneratedSourcesFilter;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.util.messages.MessageBusConnection;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidResourceUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileChangeListener
implements BulkFileListener {
    private final Object myLock;
    private final Project myProject;
    private boolean mySeenNonSourceChanges;
    private boolean mySeenLocalJavaChanges;
    private boolean mySeenLocalResourceChanges;
    @Nullable
    private MessageBusConnection myConnection;

    public FileChangeListener(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/FileChangeListener", "<init>"));
        }
        this.myLock = new Object();
        this.mySeenNonSourceChanges = true;
        this.myProject = project;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Changes getChangesAndReset() {
        Changes changes;
        Object object = this.myLock;
        synchronized (object) {
            changes = new Changes(this.mySeenNonSourceChanges, this.mySeenLocalResourceChanges, this.mySeenLocalJavaChanges);
            this.mySeenNonSourceChanges = false;
            this.mySeenLocalResourceChanges = false;
            this.mySeenLocalJavaChanges = false;
            if (changes.nonSourceChanges) {
                this.startFileListener();
            }
        }
        Changes changes2 = changes;
        if (changes2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/FileChangeListener", "getChangesAndReset"));
        }
        return changes2;
    }

    public void setEnabled(boolean en) {
        if (en) {
            this.startFileListener();
        } else {
            this.stopFileListener();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startFileListener() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnection == null) {
                this.myConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myProject);
                this.myConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopFileListener() {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myConnection != null) {
                this.myConnection.disconnect();
                this.myConnection = null;
            }
        }
    }

    public void before(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/fd/FileChangeListener", "before"));
        }
    }

    public void after(@NotNull List<? extends VFileEvent> events) {
        if (events == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/android/tools/idea/fd/FileChangeListener", "after"));
        }
        if (this.myProject.isDisposed()) {
            return;
        }
        for (VFileEvent vFileEvent : events) {
            VirtualFile file = vFileEvent.getFile();
            if (file == null) continue;
            ProjectFileIndex projectIndex = ProjectFileIndex.SERVICE.getInstance((Project)this.myProject);
            if (!projectIndex.isInSource(file)) {
                if (!file.getName().endsWith(".gradle")) continue;
                this.recordNonLocalChange();
                return;
            }
            Module module = projectIndex.getModuleForFile(file, false);
            if (module == null || GeneratedSourcesFilter.isGeneratedSourceByAnyFilter((VirtualFile)file, (Project)this.myProject)) continue;
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && !facet.isLibraryProject()) {
                FileType fileType = file.getFileType();
                if (fileType == StdFileTypes.JAVA) {
                    this.recordSimpleJavaEdit();
                    continue;
                }
                if (fileType == StdFileTypes.XML && !file.getName().equals("AndroidManifest.xml") && AndroidResourceUtil.isResourceFile(file, facet)) {
                    this.recordSimpleResourceEdit();
                    continue;
                }
                if (fileType.isBinary() && fileType == FileTypeManager.getInstance().getFileTypeByExtension("png") && AndroidResourceUtil.isResourceFile(file, facet)) {
                    this.recordSimpleResourceEdit();
                    continue;
                }
            }
            this.recordNonLocalChange();
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSimpleJavaEdit() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySeenLocalJavaChanges = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordSimpleResourceEdit() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySeenLocalResourceChanges = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recordNonLocalChange() {
        Object object = this.myLock;
        synchronized (object) {
            this.mySeenNonSourceChanges = true;
            this.stopFileListener();
        }
    }

    public static final class Changes {
        public final boolean nonSourceChanges;
        public final boolean localResourceChanges;
        public final boolean localJavaChanges;

        public Changes(boolean nonSourceChanges, boolean localResourceChanges, boolean localJavaChanges) {
            this.nonSourceChanges = nonSourceChanges;
            this.localResourceChanges = localResourceChanges;
            this.localJavaChanges = localJavaChanges;
        }
    }
}

