/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.actions;

import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.tools.fd.client.AppState;
import com.android.tools.fd.client.InstantRunClient;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.InstantRunSettings;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.fd.gradle.InstantRunGradleUtils;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.run.AndroidProcessHandler;
import com.android.tools.idea.run.AndroidSessionInfo;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import icons.AndroidIcons;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RestartActivityAction
extends AnAction {
    public RestartActivityAction() {
        super("Restart Activity", null, AndroidIcons.RunIcons.Restart);
    }

    public void update(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        if (!InstantRunSettings.isInstantRunEnabled()) {
            e.getPresentation().setEnabled(false);
            return;
        }
        AndroidGradleModel model = InstantRunGradleUtils.getAppModel(module);
        if (model == null) {
            e.getPresentation().setEnabled(false);
            return;
        }
        Project project = module.getProject();
        boolean enabled = InstantRunSettings.isInstantRunEnabled() && InstantRunGradleUtils.getIrSupportStatus(model, null) == InstantRunGradleSupport.SUPPORTED && !RestartActivityAction.getActiveSessions(project).isEmpty() && !RestartActivityAction.isDebuggerPaused(project);
        e.getPresentation().setEnabled(enabled);
    }

    private static List<ProcessHandler> getActiveSessions(@Nullable Project project) {
        if (project == null) {
            return Collections.emptyList();
        }
        ArrayList activeHandlers = Lists.newArrayList();
        for (ProcessHandler handler : ExecutionManager.getInstance((Project)project).getRunningProcesses()) {
            if (handler.isProcessTerminated() || handler.isProcessTerminating()) continue;
            activeHandlers.add(handler);
        }
        return activeHandlers;
    }

    private static boolean isDebuggerPaused(@Nullable Project project) {
        if (project == null) {
            return false;
        }
        XDebugSession session = XDebuggerManager.getInstance((Project)project).getCurrentSession();
        return session != null && !session.isStopped() && session.isPaused();
    }

    public void actionPerformed(AnActionEvent e) {
        Module module = (Module)LangDataKeys.MODULE.getData(e.getDataContext());
        if (module == null) {
            return;
        }
        InstantRunContext context = InstantRunGradleUtils.createGradleProjectContext(module);
        if (context == null) {
            Logger.getInstance(RestartActivityAction.class).info("Unable to obtain instant run context for module: " + module.getName());
            return;
        }
        RestartActivityAction.restartActivity(module.getProject(), context);
    }

    public static void restartActivity(@NotNull Project project, @NotNull InstantRunContext instantRunContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/actions/RestartActivityAction", "restartActivity"));
        }
        if (instantRunContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "instantRunContext", "com/android/tools/idea/fd/actions/RestartActivityAction", "restartActivity"));
        }
        for (IDevice device : RestartActivityAction.findDevices(project)) {
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(instantRunContext);
            if (instantRunClient == null) {
                Logger.getInstance(RestartActivityAction.class).warn("Unable to connect to to app running on device, not restarting.");
                return;
            }
            try {
                if (instantRunClient.getAppState(device) != AppState.FOREGROUND) continue;
                instantRunClient.restartActivity(device);
                if (!InstantRunSettings.isShowToastEnabled()) continue;
                RestartActivityAction.showToast(device, instantRunContext, "Activity Restarted");
            }
            catch (IOException e) {
                Messages.showErrorDialog((Project)project, (String)("Unable to restart activity: " + e), (String)"Instant Run");
                InstantRunManager.LOG.warn("Unable to restart activity", (Throwable)e);
            }
        }
    }

    @NotNull
    private static List<IDevice> findDevices(@Nullable Project project) {
        if (project == null) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/RestartActivityAction", "findDevices"));
            }
            return list;
        }
        List runningProcesses = ExecutionManager.getInstance((Project)project).getContentManager().getAllDescriptors();
        if (runningProcesses.isEmpty()) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/RestartActivityAction", "findDevices"));
            }
            return list;
        }
        ArrayList devices = Lists.newArrayList();
        for (RunContentDescriptor descriptor : runningProcesses) {
            ProcessHandler processHandler = descriptor.getProcessHandler();
            if (processHandler == null || processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) continue;
            devices.addAll(RestartActivityAction.getConnectedDevices(processHandler));
        }
        ArrayList arrayList = devices;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/RestartActivityAction", "findDevices"));
        }
        return arrayList;
    }

    @NotNull
    private static List<IDevice> getConnectedDevices(@NotNull ProcessHandler processHandler) {
        if (processHandler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processHandler", "com/android/tools/idea/fd/actions/RestartActivityAction", "getConnectedDevices"));
        }
        if (processHandler.isProcessTerminated() || processHandler.isProcessTerminating()) {
            List<IDevice> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/RestartActivityAction", "getConnectedDevices"));
            }
            return list;
        }
        if (processHandler instanceof AndroidProcessHandler) {
            ImmutableList immutableList = ImmutableList.copyOf(((AndroidProcessHandler)processHandler).getDevices());
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/RestartActivityAction", "getConnectedDevices"));
            }
            return immutableList;
        }
        Client c = (Client)processHandler.getUserData(AndroidSessionInfo.ANDROID_DEBUG_CLIENT);
        if (c != null && c.isValid()) {
            List<IDevice> list = Collections.singletonList(c.getDevice());
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/RestartActivityAction", "getConnectedDevices"));
            }
            return list;
        }
        List<IDevice> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/actions/RestartActivityAction", "getConnectedDevices"));
        }
        return list;
    }

    private static void showToast(@NotNull IDevice device, @NotNull InstantRunContext context, @NotNull String message) {
        if (device == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "device", "com/android/tools/idea/fd/actions/RestartActivityAction", "showToast"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/fd/actions/RestartActivityAction", "showToast"));
        }
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/fd/actions/RestartActivityAction", "showToast"));
        }
        try {
            InstantRunClient instantRunClient = InstantRunManager.getInstantRunClient(context);
            if (instantRunClient == null) {
                InstantRunManager.LOG.warn("Cannot connect to app, not showing toast");
                return;
            }
            instantRunClient.showToast(device, message);
        }
        catch (Throwable e) {
            InstantRunManager.LOG.warn(e);
        }
    }
}

