/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.fd.gradle;

import com.android.builder.model.BuildType;
import com.android.builder.model.BuildTypeContainer;
import com.android.builder.model.InstantRun;
import com.android.builder.model.ProductFlavor;
import com.android.builder.model.Variant;
import com.android.ide.common.repository.GradleVersion;
import com.android.sdklib.AndroidVersion;
import com.android.tools.fd.client.InstantRunBuildInfo;
import com.android.tools.idea.fd.InstantRunContext;
import com.android.tools.idea.fd.InstantRunManager;
import com.android.tools.idea.fd.gradle.InstantRunGradleSupport;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.run.GradleInstantRunContext;
import com.android.tools.idea.run.ApkProviderUtil;
import com.android.tools.idea.run.ApkProvisionException;
import com.google.common.base.Charsets;
import com.google.common.io.Files;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InstantRunGradleUtils {
    @NotNull
    public static InstantRunGradleSupport getIrSupportStatus(@Nullable AndroidGradleModel model, @Nullable AndroidVersion deviceVersion) {
        ProductFlavor mergedFlavor;
        block16: {
            InstantRunGradleSupport instantRunGradleSupport;
            if (model == null) {
                InstantRunGradleSupport instantRunGradleSupport2 = InstantRunGradleSupport.NO_GRADLE_MODEL;
                if (instantRunGradleSupport2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
                }
                return instantRunGradleSupport2;
            }
            if (!InstantRunGradleUtils.modelSupportsInstantRun(model)) {
                if (model.getAndroidProject().getPluginGeneration() == 2) {
                    InstantRunGradleSupport instantRunGradleSupport3 = InstantRunGradleSupport.USES_EXPERIMENTAL_PLUGIN;
                    if (instantRunGradleSupport3 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
                    }
                    return instantRunGradleSupport3;
                }
                InstantRunGradleSupport instantRunGradleSupport4 = InstantRunGradleSupport.GRADLE_PLUGIN_TOO_OLD;
                if (instantRunGradleSupport4 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
                }
                return instantRunGradleSupport4;
            }
            try {
                InstantRunGradleSupport modelStatus = InstantRunGradleSupport.fromModel(model);
                if (modelStatus == InstantRunGradleSupport.SUPPORTED) break block16;
                instantRunGradleSupport = modelStatus;
            }
            catch (UnsupportedOperationException e) {
                if (InstantRunGradleUtils.variantSupportsInstantRun(model)) break block16;
                InstantRunGradleSupport instantRunGradleSupport5 = InstantRunGradleSupport.VARIANT_DOES_NOT_SUPPORT_INSTANT_RUN;
                if (instantRunGradleSupport5 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
                }
                return instantRunGradleSupport5;
            }
            if (instantRunGradleSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return instantRunGradleSupport;
        }
        if (deviceVersion == null) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.SUPPORTED;
            if (instantRunGradleSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return instantRunGradleSupport;
        }
        Variant variant = model.getSelectedVariant();
        BuildTypeContainer buildTypeContainer = model.findBuildType(model.getSelectedVariant().getBuildType());
        assert (buildTypeContainer != null);
        BuildType buildType = buildTypeContainer.getBuildType();
        if (InstantRunGradleUtils.isLegacyMultiDex(buildType, mergedFlavor = variant.getMergedFlavor()) && !deviceVersion.isGreaterOrEqualThan(AndroidVersion.ART_RUNTIME.getApiLevel())) {
            InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.LEGACY_MULTIDEX_REQUIRES_ART;
            if (instantRunGradleSupport == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
            }
            return instantRunGradleSupport;
        }
        InstantRunGradleSupport instantRunGradleSupport = InstantRunGradleSupport.SUPPORTED;
        if (instantRunGradleSupport == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getIrSupportStatus"));
        }
        return instantRunGradleSupport;
    }

    private static boolean isLegacyMultiDex(@NotNull BuildType buildType, @NotNull ProductFlavor mergedFlavor) {
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "isLegacyMultiDex"));
        }
        if (mergedFlavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mergedFlavor", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "isLegacyMultiDex"));
        }
        if (buildType.getMultiDexEnabled() != null) {
            return buildType.getMultiDexEnabled();
        }
        if (mergedFlavor.getMultiDexEnabled() != null) {
            return mergedFlavor.getMultiDexEnabled();
        }
        return false;
    }

    public static boolean variantSupportsInstantRun(@NotNull AndroidGradleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "variantSupportsInstantRun"));
        }
        try {
            return model.getSelectedVariant().getMainArtifact().getInstantRun().isSupportedByArtifact();
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean modelSupportsInstantRun(@NotNull AndroidGradleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "modelSupportsInstantRun"));
        }
        GradleVersion modelVersion = model.getModelVersion();
        return modelVersion == null || modelVersion.compareTo(InstantRunManager.MINIMUM_GRADLE_PLUGIN_VERSION) >= 0;
    }

    @Nullable
    public static AndroidGradleModel getAppModel(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getAppModel"));
        }
        AndroidFacet facet = InstantRunGradleUtils.findAppModule(module, module.getProject());
        if (facet == null) {
            return null;
        }
        return AndroidGradleModel.get(facet);
    }

    @Nullable
    public static AndroidFacet findAppModule(@Nullable Module module, @NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "findAppModule"));
        }
        if (module != null) {
            assert (module.getProject() == project);
            AndroidFacet facet = AndroidFacet.getInstance(module);
            if (facet != null && !facet.isLibraryProject()) {
                return facet;
            }
        }
        for (Module m : ModuleManager.getInstance((Project)project).getModules()) {
            AndroidFacet facet = AndroidFacet.getInstance(m);
            if (facet == null || facet.isLibraryProject()) continue;
            return facet;
        }
        return null;
    }

    @Nullable
    public static InstantRunBuildInfo getBuildInfo(AndroidGradleModel model) {
        String xml;
        File buildInfo = InstantRunGradleUtils.getLocalBuildInfoFile(model);
        if (!buildInfo.exists()) {
            return null;
        }
        try {
            xml = Files.toString((File)buildInfo, (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
        return InstantRunBuildInfo.get((String)xml);
    }

    @NotNull
    private static File getLocalBuildInfoFile(@NotNull AndroidGradleModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getLocalBuildInfoFile"));
        }
        InstantRun instantRun = model.getSelectedVariant().getMainArtifact().getInstantRun();
        File file = instantRun.getInfoFile();
        if (file == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "getLocalBuildInfoFile"));
        }
        return file;
    }

    @Nullable
    public static InstantRunContext createGradleProjectContext(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "createGradleProjectContext"));
        }
        AndroidFacet appFacet = InstantRunGradleUtils.findAppModule(module, module.getProject());
        if (appFacet == null) {
            return null;
        }
        return InstantRunGradleUtils.createGradleProjectContext(appFacet);
    }

    @Nullable
    public static InstantRunContext createGradleProjectContext(@NotNull AndroidFacet facet) {
        if (facet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "com/android/tools/idea/fd/gradle/InstantRunGradleUtils", "createGradleProjectContext"));
        }
        try {
            String pkgName = ApkProviderUtil.computePackageName(facet);
            return new GradleInstantRunContext(pkgName, facet);
        }
        catch (ApkProvisionException e) {
            return null;
        }
    }
}

