/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model;

import com.android.tools.idea.gradle.dsl.model.GradleFileModel;
import com.android.tools.idea.gradle.dsl.parser.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.util.PropertiesUtil;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradlePropertiesModel
extends GradleFileModel {
    private static final Logger LOG = Logger.getInstance(GradlePropertiesModel.class);

    @Nullable
    public static GradlePropertiesModel parsePropertiesFile(@NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel", "parsePropertiesFile"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel", "parsePropertiesFile"));
        }
        if (moduleName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel", "parsePropertiesFile"));
        }
        File propertiesFile = VfsUtilCore.virtualToIoFile((VirtualFile)file);
        try {
            Properties properties = PropertiesUtil.getProperties(propertiesFile);
            GradlePropertiesFile gradlePropertiesFile = new GradlePropertiesFile(properties, file, project, moduleName);
            return new GradlePropertiesModel(gradlePropertiesFile);
        }
        catch (IOException e) {
            LOG.warn("Failed to process " + file.getPath(), (Throwable)e);
            return null;
        }
    }

    private GradlePropertiesModel(@NotNull GradleDslFile gradleDslFile) {
        if (gradleDslFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleDslFile", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel", "<init>"));
        }
        super(gradleDslFile);
    }

    private static class GradlePropertyElement
    extends GradleDslExpression {
        @Nullable
        private Object myValue;

        private GradlePropertyElement(@Nullable GradleDslElement parent, @NotNull String name) {
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertyElement", "<init>"));
            }
            super(parent, null, name, null);
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.myValue;
        }

        @Override
        @Nullable
        public <T> T getValue(@NotNull Class<T> clazz) {
            if (clazz == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertyElement", "getValue"));
            }
            Object value = this.getValue();
            if (clazz.isInstance(value)) {
                return clazz.cast(value);
            }
            return null;
        }

        @Override
        public void setValue(@NotNull Object value) {
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertyElement", "setValue"));
            }
            this.myValue = value;
        }

        @Override
        @NotNull
        protected Collection<GradleDslElement> getChildren() {
            ImmutableList immutableList = ImmutableList.of();
            if (immutableList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertyElement", "getChildren"));
            }
            return immutableList;
        }

        @Override
        protected void apply() {
        }

        @Override
        protected void reset() {
        }
    }

    private static final class GradlePropertiesFile
    extends GradleDslFile {
        private final Properties myProperties;

        private GradlePropertiesFile(@NotNull Properties properties, @NotNull VirtualFile file, @NotNull Project project, @NotNull String moduleName) {
            if (properties == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertiesFile", "<init>"));
            }
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertiesFile", "<init>"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertiesFile", "<init>"));
            }
            if (moduleName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "moduleName", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertiesFile", "<init>"));
            }
            super(file, project, moduleName);
            this.myProperties = properties;
        }

        @Override
        public void parse() {
        }

        @Override
        @Nullable
        public GradleDslExpression getPropertyElement(@NotNull String property) {
            if (property == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/model/GradlePropertiesModel$GradlePropertiesFile", "getPropertyElement"));
            }
            String value = this.myProperties.getProperty(property);
            if (value == null) {
                return null;
            }
            GradlePropertyElement propertyElement = new GradlePropertyElement((GradleDslElement)this, property);
            propertyElement.setValue(value);
            return propertyElement;
        }
    }
}

