/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.model.android;

import com.android.tools.idea.gradle.dsl.model.GradleDslBlockModel;
import com.android.tools.idea.gradle.dsl.model.android.BuildTypeModel;
import com.android.tools.idea.gradle.dsl.model.android.CompileOptionsModel;
import com.android.tools.idea.gradle.dsl.model.android.ProductFlavorModel;
import com.android.tools.idea.gradle.dsl.model.android.external.ExternalNativeBuildModel;
import com.android.tools.idea.gradle.dsl.parser.android.AndroidDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypeDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.BuildTypesDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.CompileOptionsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.ProductFlavorsDslElement;
import com.android.tools.idea.gradle.dsl.parser.android.external.ExternalNativeBuildDslElement;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidModel
extends GradleDslBlockModel {
    @NonNls
    private static final String BUILD_TOOLS_VERSION = "buildToolsVersion";
    @NonNls
    private static final String COMPILE_SDK_VERSION = "compileSdkVersion";
    @NonNls
    private static final String DEFAULT_CONFIG = "defaultConfig";
    @NonNls
    private static final String DEFAULT_PUBLISH_CONFIG = "defaultPublishConfig";
    @NonNls
    private static final String FLAVOR_DIMENSIONS = "flavorDimensions";
    @NonNls
    private static final String GENERATE_PURE_SPLITS = "generatePureSplits";
    @NonNls
    private static final String PUBLISH_NON_DEFAULT = "publishNonDefault";
    @NonNls
    private static final String RESOURCE_PREFIX = "resourcePrefix";

    public AndroidModel(@NotNull AndroidDslElement dslElement) {
        if (dslElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dslElement", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "<init>"));
        }
        super(dslElement);
    }

    @Nullable
    public String buildToolsVersion() {
        Integer intValue = this.myDslElement.getProperty(BUILD_TOOLS_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(BUILD_TOOLS_VERSION, String.class);
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(int buildToolsVersion) {
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setBuildToolsVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel setBuildToolsVersion(@NotNull String buildToolsVersion) {
        if (buildToolsVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", BUILD_TOOLS_VERSION, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setBuildToolsVersion"));
        }
        this.myDslElement.setNewLiteral(BUILD_TOOLS_VERSION, buildToolsVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setBuildToolsVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeBuildToolsVersion() {
        this.myDslElement.removeProperty(BUILD_TOOLS_VERSION);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeBuildToolsVersion"));
        }
        return androidModel;
    }

    @NotNull
    public Collection<BuildTypeModel> buildTypes() {
        BuildTypesDslElement buildTypes = this.myDslElement.getProperty("buildTypes", BuildTypesDslElement.class);
        Object object = buildTypes == null ? ImmutableList.of() : buildTypes.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "buildTypes"));
        }
        return object;
    }

    @NotNull
    public AndroidModel addBuildType(@NotNull String buildType) {
        BuildTypeDslElement buildTypeElement;
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addBuildType"));
        }
        BuildTypesDslElement buildTypes = this.myDslElement.getProperty("buildTypes", BuildTypesDslElement.class);
        if (buildTypes == null) {
            buildTypes = new BuildTypesDslElement(this.myDslElement);
            this.myDslElement.setNewElement("buildTypes", buildTypes);
        }
        if ((buildTypeElement = buildTypes.getProperty(buildType, BuildTypeDslElement.class)) == null) {
            buildTypeElement = new BuildTypeDslElement(buildTypes, buildType);
            buildTypes.setNewElement(buildType, buildTypeElement);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addBuildType"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeBuildType(@NotNull String buildType) {
        if (buildType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildType", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeBuildType"));
        }
        BuildTypesDslElement buildTypes = this.myDslElement.getProperty("buildTypes", BuildTypesDslElement.class);
        if (buildTypes != null) {
            buildTypes.removeProperty(buildType);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeBuildType"));
        }
        return androidModel;
    }

    @NotNull
    public CompileOptionsModel compileOptions() {
        CompileOptionsDslElement element = this.myDslElement.getProperty("compileOptions", CompileOptionsDslElement.class);
        if (element == null) {
            element = new CompileOptionsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("compileOptions", element);
        }
        CompileOptionsModel compileOptionsModel = new CompileOptionsModel(element, false);
        if (compileOptionsModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "compileOptions"));
        }
        return compileOptionsModel;
    }

    @Nullable
    public String compileSdkVersion() {
        Integer intValue = this.myDslElement.getProperty(COMPILE_SDK_VERSION, Integer.class);
        return intValue != null ? intValue.toString() : this.myDslElement.getProperty(COMPILE_SDK_VERSION, String.class);
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(int compileSdkVersion) {
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setCompileSdkVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel setCompileSdkVersion(@NotNull String compileSdkVersion) {
        if (compileSdkVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", COMPILE_SDK_VERSION, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setCompileSdkVersion"));
        }
        this.myDslElement.setNewLiteral(COMPILE_SDK_VERSION, compileSdkVersion);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setCompileSdkVersion"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeCompileSdkVersion() {
        this.myDslElement.removeProperty(COMPILE_SDK_VERSION);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeCompileSdkVersion"));
        }
        return androidModel;
    }

    @NotNull
    public ProductFlavorModel defaultConfig() {
        ProductFlavorDslElement defaultConfigElement = this.myDslElement.getProperty(DEFAULT_CONFIG, ProductFlavorDslElement.class);
        if (defaultConfigElement == null) {
            defaultConfigElement = new ProductFlavorDslElement(this.myDslElement, DEFAULT_CONFIG);
            this.myDslElement.setNewElement(DEFAULT_CONFIG, defaultConfigElement);
        }
        ProductFlavorModel productFlavorModel = new ProductFlavorModel(defaultConfigElement);
        if (productFlavorModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", DEFAULT_CONFIG));
        }
        return productFlavorModel;
    }

    @Nullable
    public String defaultPublishConfig() {
        return this.myDslElement.getProperty(DEFAULT_PUBLISH_CONFIG, String.class);
    }

    @NotNull
    public AndroidModel setDefaultPublishConfig(@NotNull String defaultPublishConfig) {
        if (defaultPublishConfig == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", DEFAULT_PUBLISH_CONFIG, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setDefaultPublishConfig"));
        }
        this.myDslElement.setNewLiteral(DEFAULT_PUBLISH_CONFIG, defaultPublishConfig);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setDefaultPublishConfig"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeDefaultPublishConfig() {
        this.myDslElement.removeProperty(DEFAULT_PUBLISH_CONFIG);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeDefaultPublishConfig"));
        }
        return androidModel;
    }

    @NotNull
    public ExternalNativeBuildModel externalNativeBuild() {
        ExternalNativeBuildDslElement externalNativeBuildDslElement = this.myDslElement.getProperty("externalNativeBuild", ExternalNativeBuildDslElement.class);
        if (externalNativeBuildDslElement == null) {
            externalNativeBuildDslElement = new ExternalNativeBuildDslElement(this.myDslElement);
            this.myDslElement.setNewElement("externalNativeBuild", externalNativeBuildDslElement);
        }
        ExternalNativeBuildModel externalNativeBuildModel = new ExternalNativeBuildModel(externalNativeBuildDslElement);
        if (externalNativeBuildModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "externalNativeBuild"));
        }
        return externalNativeBuildModel;
    }

    @Nullable
    public List<String> flavorDimensions() {
        return this.myDslElement.getListProperty(FLAVOR_DIMENSIONS, String.class);
    }

    @NotNull
    public AndroidModel addFlavorDimension(@NotNull String flavorDimension) {
        if (flavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addFlavorDimension"));
        }
        this.myDslElement.addToNewLiteralList(FLAVOR_DIMENSIONS, flavorDimension);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addFlavorDimension"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeFlavorDimension(@NotNull String flavorDimension) {
        if (flavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeFlavorDimension"));
        }
        this.myDslElement.removeFromExpressionList(FLAVOR_DIMENSIONS, flavorDimension);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeFlavorDimension"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeAllFlavorDimensions() {
        this.myDslElement.removeProperty(FLAVOR_DIMENSIONS);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeAllFlavorDimensions"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel replaceFlavorDimension(@NotNull String oldFlavorDimension, @NotNull String newFlavorDimension) {
        if (oldFlavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldFlavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "replaceFlavorDimension"));
        }
        if (newFlavorDimension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newFlavorDimension", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "replaceFlavorDimension"));
        }
        this.myDslElement.replaceInExpressionList(FLAVOR_DIMENSIONS, oldFlavorDimension, newFlavorDimension);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "replaceFlavorDimension"));
        }
        return androidModel;
    }

    @Nullable
    public Boolean generatePureSplits() {
        return this.myDslElement.getProperty(GENERATE_PURE_SPLITS, Boolean.class);
    }

    @NotNull
    public AndroidModel setGeneratePureSplits(boolean generatePureSplits) {
        this.myDslElement.setNewLiteral(GENERATE_PURE_SPLITS, generatePureSplits);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setGeneratePureSplits"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeGeneratePureSplits() {
        this.myDslElement.removeProperty(GENERATE_PURE_SPLITS);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeGeneratePureSplits"));
        }
        return androidModel;
    }

    @NotNull
    public Collection<ProductFlavorModel> productFlavors() {
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        Object object = productFlavors == null ? ImmutableList.of() : productFlavors.get();
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "productFlavors"));
        }
        return object;
    }

    @NotNull
    public AndroidModel addProductFlavor(@NotNull String flavor) {
        ProductFlavorDslElement flavorElement;
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addProductFlavor"));
        }
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors == null) {
            productFlavors = new ProductFlavorsDslElement(this.myDslElement);
            this.myDslElement.setNewElement("productFlavors", productFlavors);
        }
        if ((flavorElement = productFlavors.getProperty(flavor, ProductFlavorDslElement.class)) == null) {
            flavorElement = new ProductFlavorDslElement(productFlavors, flavor);
            productFlavors.setNewElement(flavor, flavorElement);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "addProductFlavor"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeProductFlavor(@NotNull String flavor) {
        if (flavor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "flavor", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeProductFlavor"));
        }
        ProductFlavorsDslElement productFlavors = this.myDslElement.getProperty("productFlavors", ProductFlavorsDslElement.class);
        if (productFlavors != null) {
            productFlavors.removeProperty(flavor);
        }
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeProductFlavor"));
        }
        return androidModel;
    }

    @Nullable
    public Boolean publishNonDefault() {
        return this.myDslElement.getProperty(PUBLISH_NON_DEFAULT, Boolean.class);
    }

    @NotNull
    public AndroidModel setPublishNonDefault(boolean publishNonDefault) {
        this.myDslElement.setNewLiteral(PUBLISH_NON_DEFAULT, publishNonDefault);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setPublishNonDefault"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removePublishNonDefault() {
        this.myDslElement.removeProperty(PUBLISH_NON_DEFAULT);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removePublishNonDefault"));
        }
        return androidModel;
    }

    @Nullable
    public String resourcePrefix() {
        return this.myDslElement.getProperty(RESOURCE_PREFIX, String.class);
    }

    @NotNull
    public AndroidModel setResourcePrefix(@NotNull String resourcePrefix) {
        if (resourcePrefix == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", RESOURCE_PREFIX, "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setResourcePrefix"));
        }
        this.myDslElement.setNewLiteral(RESOURCE_PREFIX, resourcePrefix);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "setResourcePrefix"));
        }
        return androidModel;
    }

    @NotNull
    public AndroidModel removeResourcePrefix() {
        this.myDslElement.removeProperty(RESOURCE_PREFIX);
        AndroidModel androidModel = this;
        if (androidModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/model/android/AndroidModel", "removeResourcePrefix"));
        }
        return androidModel;
    }
}

