/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.elements;

import com.android.tools.idea.gradle.dsl.model.values.GradleNullableValue;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslElement;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpression;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionList;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslExpressionMap;
import com.android.tools.idea.gradle.dsl.parser.elements.GradleDslLiteral;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;

public abstract class GradlePropertiesDslElement
extends GradleDslElement {
    @NotNull
    private Map<String, GradleDslElement> myProperties;
    @NotNull
    private Map<String, GradleDslElement> myToBeAddedProperties;
    @NotNull
    private Set<String> myToBeRemovedProperties;

    protected GradlePropertiesDslElement(@Nullable GradleDslElement parent, @Nullable GroovyPsiElement psiElement, @NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "<init>"));
        }
        super(parent, psiElement, name);
        this.myProperties = Maps.newLinkedHashMap();
        this.myToBeAddedProperties = Maps.newLinkedHashMap();
        this.myToBeRemovedProperties = Sets.newLinkedHashSet();
    }

    public void setParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setParsedElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setParsedElement"));
        }
        element.myParent = this;
        this.myProperties.put(property, element);
    }

    public void addParsedElement(@NotNull String property, @NotNull GradleDslElement element) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addParsedElement"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addParsedElement"));
        }
        element.myParent = this;
        this.myProperties.put(property, element);
    }

    protected void addAsParsedDslExpressionList(@NotNull String property, GradleDslExpression dslLiteral) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addAsParsedDslExpressionList"));
        }
        GroovyPsiElement psiElement = dslLiteral.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList literalList = new GradleDslExpressionList(this, psiElement, property);
        literalList.addParsedExpression(dslLiteral);
        this.myProperties.put(property, literalList);
    }

    public void addToParsedExpressionList(@NotNull String property, @NotNull GradleDslElement element) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToParsedExpressionList"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToParsedExpressionList"));
        }
        GroovyPsiElement psiElement = element.getPsiElement();
        if (psiElement == null) {
            return;
        }
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList(this, psiElement, property);
            this.myProperties.put(property, gradleDslExpressionList);
        } else {
            gradleDslExpressionList.setPsiElement(psiElement);
        }
        if (element instanceof GradleDslExpression) {
            gradleDslExpressionList.addParsedExpression((GradleDslExpression)element);
        } else if (element instanceof GradleDslExpressionList) {
            List<GradleDslExpression> gradleExpressions = ((GradleDslExpressionList)element).getExpressions();
            for (GradleDslExpression expression : gradleExpressions) {
                gradleDslExpressionList.addParsedExpression(expression);
            }
        }
    }

    @NotNull
    public List<String> getProperties() {
        ArrayList result = Lists.newArrayList();
        result.addAll(this.myProperties.keySet());
        result.addAll(this.myToBeAddedProperties.keySet());
        result.removeAll(this.myToBeRemovedProperties);
        ArrayList arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getProperties"));
        }
        return arrayList;
    }

    @NotNull
    public Map<String, GradleDslElement> getPropertyElements() {
        LinkedHashMap result = Maps.newLinkedHashMap();
        result.putAll(this.myProperties);
        result.putAll(this.myToBeAddedProperties);
        for (String toBeRemoved : this.myToBeRemovedProperties) {
            result.remove(toBeRemoved);
        }
        LinkedHashMap linkedHashMap = result;
        if (linkedHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getPropertyElements"));
        }
        return linkedHashMap;
    }

    @Nullable
    public GradleDslElement getPropertyElement(@NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getPropertyElement"));
        }
        if (!property.contains(".")) {
            if (this.myToBeRemovedProperties.contains(property)) {
                return null;
            }
            GradleDslElement toBeAddedElement = this.myToBeAddedProperties.get(property);
            return toBeAddedElement != null ? toBeAddedElement : this.myProperties.get(property);
        }
        List propertyNameSegments = Splitter.on((char)'.').splitToList((CharSequence)property);
        GradlePropertiesDslElement nestedElement = this;
        for (int i = 0; i < propertyNameSegments.size() - 1; ++i) {
            GradleDslElement element = nestedElement.getPropertyElement(((String)propertyNameSegments.get(i)).trim());
            if (!(element instanceof GradlePropertiesDslElement)) {
                return null;
            }
            nestedElement = (GradlePropertiesDslElement)element;
        }
        return nestedElement.getPropertyElement((String)propertyNameSegments.get(propertyNameSegments.size() - 1));
    }

    @NotNull
    public <T> GradleNullableValue<T> getPropertyValue(@NotNull String property, @NotNull Class<T> clazz) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getPropertyValue"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getPropertyValue"));
        }
        GradleDslElement propertyElement = this.getPropertyElement(property);
        if (propertyElement != null) {
            Object resultValue = null;
            if (clazz.isInstance(propertyElement)) {
                resultValue = clazz.cast(propertyElement);
            } else if (propertyElement instanceof GradleDslExpression) {
                resultValue = ((GradleDslExpression)propertyElement).getValue(clazz);
            }
            if (resultValue != null) {
                GradleNullableValue<Object> gradleNullableValue = new GradleNullableValue<Object>(propertyElement, resultValue);
                if (gradleNullableValue == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getPropertyValue"));
                }
                return gradleNullableValue;
            }
        }
        GradleNullableValue<Object> gradleNullableValue = new GradleNullableValue<Object>(this, null);
        if (gradleNullableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getPropertyValue"));
        }
        return gradleNullableValue;
    }

    @Nullable
    public <T> T getProperty(@NotNull String property, @NotNull Class<T> clazz) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getProperty"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getProperty"));
        }
        return this.getPropertyValue(property, clazz).value();
    }

    @NotNull
    public GradlePropertiesDslElement setNewElement(@NotNull String property, @NotNull GradleDslElement newElement) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewElement"));
        }
        if (newElement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newElement", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewElement"));
        }
        newElement.myParent = this;
        this.myToBeAddedProperties.put(property, newElement);
        this.setModified(true);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewElement"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setNewLiteral(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setNewLiteralImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setNewLiteral(@NotNull String property, @NotNull Integer value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setNewLiteralImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setNewLiteral(@NotNull String property, @NotNull Boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setNewLiteralImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteral"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement setNewLiteralImpl(@NotNull String property, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteralImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteralImpl"));
        }
        GradleDslLiteral literalElement = this.getProperty(property, GradleDslLiteral.class);
        if (literalElement == null) {
            literalElement = new GradleDslLiteral(this, property);
            this.myToBeAddedProperties.put(property, literalElement);
        }
        literalElement.setValue(value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setNewLiteralImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement addToNewLiteralList(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToNewLiteralList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToNewLiteralList"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.addToNewLiteralListImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToNewLiteralList"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement addToNewLiteralListImpl(@NotNull String property, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToNewLiteralListImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToNewLiteralListImpl"));
        }
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList == null) {
            gradleDslExpressionList = new GradleDslExpressionList(this, property);
            this.myToBeAddedProperties.put(property, gradleDslExpressionList);
        }
        gradleDslExpressionList.addNewLiteral(value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "addToNewLiteralListImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionList(@NotNull String property, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionList"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionList"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.removeFromExpressionListImpl(property, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionList"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement removeFromExpressionListImpl(@NotNull String property, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionListImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionListImpl"));
        }
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            gradleDslExpressionList.removeExpression(value);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionListImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement replaceInExpressionList(@NotNull String property, @NotNull String oldValue, @NotNull String newValue) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionList"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionList"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionList"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.replaceInExpressionListImpl(property, oldValue, newValue);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionList"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement replaceInExpressionListImpl(@NotNull String property, @NotNull Object oldValue, @NotNull Object newValue) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionListImpl"));
        }
        if (oldValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionListImpl"));
        }
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newValue", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionListImpl"));
        }
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            gradleDslExpressionList.replaceExpression(oldValue, newValue);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "replaceInExpressionListImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property, @NotNull String name, @NotNull String value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInNewLiteralMapImpl(property, name, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property, @NotNull String name, @NotNull Integer value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInNewLiteralMapImpl(property, name, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement setInNewLiteralMap(@NotNull String property, @NotNull String name, @NotNull Boolean value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this.setInNewLiteralMapImpl(property, name, value);
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMap"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    private GradlePropertiesDslElement setInNewLiteralMapImpl(@NotNull String property, @NotNull String name, @NotNull Object value) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMapImpl"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMapImpl"));
        }
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMapImpl"));
        }
        GradleDslExpressionMap gradleDslExpressionMap = this.getProperty(property, GradleDslExpressionMap.class);
        if (gradleDslExpressionMap == null) {
            gradleDslExpressionMap = new GradleDslExpressionMap(this, property);
            this.myToBeAddedProperties.put(property, gradleDslExpressionMap);
        }
        gradleDslExpressionMap.addNewLiteral(name, value);
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "setInNewLiteralMapImpl"));
        }
        return gradlePropertiesDslElement;
    }

    @NotNull
    public GradlePropertiesDslElement removeFromExpressionMap(@NotNull String property, @NotNull String name) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionMap"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionMap"));
        }
        GradleDslExpressionMap gradleDslExpressionMap = this.getProperty(property, GradleDslExpressionMap.class);
        if (gradleDslExpressionMap != null) {
            gradleDslExpressionMap.removeProperty(name);
        }
        GradlePropertiesDslElement gradlePropertiesDslElement = this;
        if (gradlePropertiesDslElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeFromExpressionMap"));
        }
        return gradlePropertiesDslElement;
    }

    public void removeProperty(@NotNull String property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "removeProperty"));
        }
        this.myToBeRemovedProperties.add(property);
        this.setModified(true);
    }

    @Nullable
    public <E> List<E> getListProperty(@NotNull String property, @NotNull Class<E> clazz) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getListProperty"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getListProperty"));
        }
        GradleDslExpressionList gradleDslExpressionList = this.getProperty(property, GradleDslExpressionList.class);
        if (gradleDslExpressionList != null) {
            return gradleDslExpressionList.getValues(clazz);
        }
        return null;
    }

    @Nullable
    public <V> Map<String, V> getMapProperty(@NotNull String property, @NotNull Class<V> clazz) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getMapProperty"));
        }
        if (clazz == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "clazz", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getMapProperty"));
        }
        GradleDslExpressionMap gradleDslExpressionMap = this.getProperty(property, GradleDslExpressionMap.class);
        if (gradleDslExpressionMap != null) {
            return gradleDslExpressionMap.getValues(clazz);
        }
        return null;
    }

    @Override
    @NotNull
    protected Collection<GradleDslElement> getChildren() {
        Collection<GradleDslElement> collection = this.getPropertyElements().values();
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/dsl/parser/elements/GradlePropertiesDslElement", "getChildren"));
        }
        return collection;
    }

    @Override
    protected void apply() {
        for (Map.Entry<String, GradleDslElement> entry : this.myToBeAddedProperties.entrySet()) {
            String property = entry.getKey();
            GradleDslElement element = entry.getValue();
            if (element.create() == null) continue;
            this.setParsedElement(property, element);
        }
        this.myToBeAddedProperties.clear();
        for (String property : this.myToBeRemovedProperties) {
            GradleDslElement element = this.myProperties.remove(property);
            if (element == null) continue;
            element.delete();
        }
        this.myToBeRemovedProperties.clear();
        for (GradleDslElement element : this.myProperties.values()) {
            if (!element.isModified()) continue;
            element.applyChanges();
        }
    }

    @Override
    protected void reset() {
        for (GradleDslElement element : this.getPropertyElements().values()) {
            if (!element.isModified()) continue;
            element.resetState();
        }
        this.myToBeAddedProperties.clear();
        this.myToBeRemovedProperties.clear();
    }

    protected void clear() {
        this.myToBeRemovedProperties.clear();
        this.myToBeAddedProperties.clear();
        this.myProperties.clear();
    }
}

