/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.invoker;

import com.android.builder.model.AndroidArtifact;
import com.android.builder.model.BaseArtifact;
import com.android.tools.idea.gradle.AndroidGradleModel;
import com.android.tools.idea.gradle.facet.AndroidGradleFacet;
import com.android.tools.idea.gradle.facet.AndroidGradleFacetConfiguration;
import com.android.tools.idea.gradle.facet.JavaGradleFacet;
import com.android.tools.idea.gradle.facet.JavaGradleFacetConfiguration;
import com.android.tools.idea.gradle.invoker.GradleInvocationResult;
import com.android.tools.idea.gradle.invoker.GradleTaskExecutionContext;
import com.android.tools.idea.gradle.invoker.GradleTasksExecutor;
import com.android.tools.idea.gradle.invoker.console.view.GradleConsoleView;
import com.android.tools.idea.gradle.project.BuildSettings;
import com.android.tools.idea.gradle.util.AndroidGradleSettings;
import com.android.tools.idea.gradle.util.BuildMode;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.gradle.util.LocalProperties;
import com.android.tools.idea.gradle.util.Projects;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.externalSystem.model.ProjectSystemId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskId;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskNotificationListener;
import com.intellij.openapi.externalSystem.model.task.ExternalSystemTaskType;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ui.UIUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.gradle.tooling.CancellationTokenSource;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidCommonUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.android.model.impl.JpsAndroidModuleProperties;

public class GradleInvoker {
    private static final Logger LOG = Logger.getInstance(GradleInvoker.class);
    @NotNull
    private final Project myProject;
    @NotNull
    private final Collection<BeforeGradleInvocationTask> myBeforeTasks;
    @NotNull
    private final Collection<AfterGradleInvocationTask> myAfterTasks;
    @NotNull
    private final Map<ExternalSystemTaskId, CancellationTokenSource> myCancellationMap;

    public static GradleInvoker getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getInstance"));
        }
        return (GradleInvoker)ServiceManager.getService((Project)project, GradleInvoker.class);
    }

    public GradleInvoker(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/invoker/GradleInvoker", "<init>"));
        }
        this.myBeforeTasks = Sets.newLinkedHashSet();
        this.myAfterTasks = Sets.newLinkedHashSet();
        this.myCancellationMap = Maps.newConcurrentMap();
        this.myProject = project;
    }

    @VisibleForTesting
    void addBeforeGradleInvocationTask(@NotNull BeforeGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addBeforeGradleInvocationTask"));
        }
        this.myBeforeTasks.add(task);
    }

    public void addAfterGradleInvocationTask(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterGradleInvocationTask"));
        }
        this.myAfterTasks.add(task);
    }

    public void removeAfterGradleInvocationTask(@NotNull AfterGradleInvocationTask task) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "task", "com/android/tools/idea/gradle/invoker/GradleInvoker", "removeAfterGradleInvocationTask"));
        }
        this.myAfterTasks.remove(task);
    }

    @NotNull
    AfterGradleInvocationTask[] getAfterInvocationTasks() {
        AfterGradleInvocationTask[] afterGradleInvocationTaskArray = this.myAfterTasks.toArray(new AfterGradleInvocationTask[this.myAfterTasks.size()]);
        if (afterGradleInvocationTaskArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getAfterInvocationTasks"));
        }
        return afterGradleInvocationTaskArray;
    }

    public void cleanProject() {
        this.setProjectBuildMode(BuildMode.CLEAN);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleInvoker.findTasksToExecute(moduleManager.getModules(), BuildMode.SOURCE_GEN, TestCompileType.NONE);
        tasks.add(0, "clean");
        this.executeTasks(tasks, Collections.singletonList(GradleInvoker.createGenerateSourcesOnlyProperty()));
    }

    public void assembleTranslate() {
        this.setProjectBuildMode(BuildMode.ASSEMBLE_TRANSLATE);
        this.executeTasks(Lists.newArrayList((Object[])new String[]{"assembleTranslate"}));
    }

    public void generateSources(boolean cleanProject) {
        BuildMode buildMode = BuildMode.SOURCE_GEN;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        if (cleanProject) {
            tasks.add(0, "clean");
        }
        this.executeTasks(tasks, Collections.singletonList(GradleInvoker.createGenerateSourcesOnlyProperty()));
    }

    @NotNull
    private static String createGenerateSourcesOnlyProperty() {
        String string = AndroidGradleSettings.createProjectProperty((String)"android.injected.generateSourcesOnly", (boolean)true);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "createGenerateSourcesOnlyProperty"));
        }
        return string;
    }

    public void compileJava(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/invoker/GradleInvoker", "compileJava"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/invoker/GradleInvoker", "compileJava"));
        }
        BuildMode buildMode = BuildMode.COMPILE_JAVA;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks);
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/invoker/GradleInvoker", "assemble"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/invoker/GradleInvoker", "assemble"));
        }
        this.assemble(modules, testCompileType, Collections.emptyList());
    }

    public void assemble(@NotNull Module[] modules, @NotNull TestCompileType testCompileType, @NotNull List<String> arguments) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/invoker/GradleInvoker", "assemble"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/invoker/GradleInvoker", "assemble"));
        }
        if (arguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "arguments", "com/android/tools/idea/gradle/invoker/GradleInvoker", "assemble"));
        }
        BuildMode buildMode = BuildMode.ASSEMBLE;
        this.setProjectBuildMode(buildMode);
        List<String> tasks = GradleInvoker.findTasksToExecute(modules, buildMode, testCompileType);
        this.executeTasks(tasks, arguments);
    }

    public void rebuild() {
        BuildMode buildMode = BuildMode.REBUILD;
        this.setProjectBuildMode(buildMode);
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        List<String> tasks = GradleInvoker.findTasksToExecute(moduleManager.getModules(), buildMode, TestCompileType.NONE);
        this.executeTasks(tasks);
    }

    private void setProjectBuildMode(@NotNull BuildMode buildMode) {
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/invoker/GradleInvoker", "setProjectBuildMode"));
        }
        BuildSettings.getInstance(this.myProject).setBuildMode(buildMode);
    }

    @NotNull
    public static List<String> findCleanTasksForModules(@NotNull Module[] modules) {
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findCleanTasksForModules"));
        }
        ArrayList tasks = Lists.newArrayList();
        for (Module module : modules) {
            AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
            if (gradleFacet == null) continue;
            String gradlePath = ((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
            GradleInvoker.addTaskIfSpecified(tasks, gradlePath, "clean");
        }
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findCleanTasksForModules"));
        }
        return arrayList;
    }

    @NotNull
    public static List<String> findTasksToExecute(@NotNull Module[] modules, @NotNull BuildMode buildMode, @NotNull TestCompileType testCompileType) {
        Project project;
        if (modules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
        }
        if (buildMode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
        }
        ArrayList tasks = Lists.newArrayList();
        if (BuildMode.ASSEMBLE == buildMode && Projects.lastGradleSyncFailed(project = modules[0].getProject())) {
            List<String> list = Collections.singletonList("assemble");
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
            }
            return list;
        }
        for (Project module : modules) {
            if ("buildSrc".equals(module.getName())) continue;
            GradleInvoker.findAndAddGradleBuildTasks((Module)module, buildMode, tasks, testCompileType);
        }
        if (buildMode == BuildMode.REBUILD && !tasks.isEmpty()) {
            tasks.add(0, "clean");
        }
        if (tasks.isEmpty()) {
            String format = "Unable to find Gradle tasks for project '%1$s' using BuildMode %2$s";
            LOG.info(String.format(format, modules[0].getProject().getName(), buildMode.name()));
        }
        ArrayList arrayList = tasks;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findTasksToExecute"));
        }
        return arrayList;
    }

    public void executeTasks(@NotNull List<String> gradleTasks) {
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        this.executeTasks(gradleTasks, Collections.emptyList());
    }

    public void executeTasks(@NotNull List<String> tasks, @Nullable BuildMode buildMode, @NotNull List<String> commandLineArguments) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        if (buildMode != null) {
            this.setProjectBuildMode(buildMode);
        }
        this.executeTasks(tasks, commandLineArguments);
    }

    public void executeTasks(@NotNull List<String> gradleTasks, @NotNull List<String> commandLineArguments) {
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        ExternalSystemTaskId id = ExternalSystemTaskId.create((ProjectSystemId)GradleUtil.GRADLE_SYSTEM_ID, (ExternalSystemTaskType)ExternalSystemTaskType.EXECUTE_TASK, (Project)this.myProject);
        ArrayList jvmArguments = Lists.newArrayList();
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            File androidHomePath;
            LocalProperties localProperties;
            try {
                localProperties = new LocalProperties(this.myProject);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            if (localProperties.getAndroidSdkPath() == null && (androidHomePath = IdeSdks.getAndroidSdkPath()) != null) {
                jvmArguments.add(AndroidGradleSettings.createAndroidHomeJvmArg((String)androidHomePath.getPath()));
            }
        }
        this.executeTasks(gradleTasks, jvmArguments, commandLineArguments, id, null, null, false, false);
    }

    public void executeTasks(@NotNull List<String> gradleTasks, @NotNull List<String> jvmArguments, @NotNull List<String> commandLineArguments, @NotNull ExternalSystemTaskId taskId, @Nullable ExternalSystemTaskNotificationListener taskListener, @Nullable File buildFilePath, boolean waitForCompletion, boolean useEmbeddedGradle) {
        if (gradleTasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleTasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        if (jvmArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "jvmArguments", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        if (commandLineArguments == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "commandLineArguments", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        if (taskId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskId", "com/android/tools/idea/gradle/invoker/GradleInvoker", "executeTasks"));
        }
        LOG.info("About to execute Gradle tasks: " + gradleTasks);
        if (gradleTasks.isEmpty()) {
            return;
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            for (BeforeGradleInvocationTask listener : this.myBeforeTasks) {
                listener.execute(gradleTasks);
            }
            if (!this.myBeforeTasks.isEmpty()) {
                return;
            }
        }
        GradleTaskExecutionContext context = new GradleTaskExecutionContext(this, this.myProject, gradleTasks, jvmArguments, commandLineArguments, this.myCancellationMap, taskId, taskListener, buildFilePath, useEmbeddedGradle);
        GradleTasksExecutor executor = new GradleTasksExecutor(context);
        GradleInvoker.saveAllFilesSafely();
        if (ApplicationManager.getApplication().isDispatchThread()) {
            executor.queue();
        } else if (waitForCompletion) {
            executor.queueAndWaitForCompletion();
        } else {
            UIUtil.invokeAndWaitIfNeeded(() -> ((GradleTasksExecutor)executor).queue());
        }
    }

    public static void saveAllFilesSafely() {
        ApplicationManager.getApplication().invokeAndWait(() -> ApplicationManager.getApplication().runWriteAction(() -> FileDocumentManager.getInstance().saveAllDocuments()));
    }

    public void clearConsoleAndBuildMessages() {
        GradleConsoleView.getInstance(this.myProject).clear();
        GradleTasksExecutor.clearMessageView(this.myProject);
    }

    private static void findAndAddGradleBuildTasks(@NotNull Module module, @NotNull BuildMode buildMode, @NotNull List<String> tasks, @NotNull TestCompileType testCompileType) {
        block18: {
            String gradlePath;
            block17: {
                if (module == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findAndAddGradleBuildTasks"));
                }
                if (buildMode == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buildMode", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findAndAddGradleBuildTasks"));
                }
                if (tasks == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findAndAddGradleBuildTasks"));
                }
                if (testCompileType == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/invoker/GradleInvoker", "findAndAddGradleBuildTasks"));
                }
                AndroidGradleFacet gradleFacet = AndroidGradleFacet.getInstance(module);
                if (gradleFacet == null) {
                    return;
                }
                gradlePath = ((AndroidGradleFacetConfiguration)gradleFacet.getConfiguration()).GRADLE_PROJECT_PATH;
                if (StringUtil.isEmpty((String)gradlePath)) {
                    String msg = String.format("Module '%1$s' does not have a Gradle path. It is likely that this module was manually added by the user.", module.getName());
                    LOG.info(msg);
                    return;
                }
                AndroidFacet androidFacet = AndroidFacet.getInstance(module);
                if (androidFacet == null) break block17;
                JpsAndroidModuleProperties properties = androidFacet.getProperties();
                AndroidGradleModel androidGradleModel = AndroidGradleModel.get(module);
                switch (buildMode) {
                    case CLEAN: 
                    case SOURCE_GEN: {
                        GradleInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidGradleModel);
                        break;
                    }
                    case ASSEMBLE: {
                        tasks.add(GradleInvoker.createBuildTask(gradlePath, properties.ASSEMBLE_TASK_NAME));
                        if (testCompileType != TestCompileType.NONE) {
                            for (BaseArtifact artifact : GradleInvoker.getArtifactsForTestCompileType(testCompileType, androidGradleModel)) {
                                GradleInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getAssembleTaskName());
                            }
                        }
                        break block18;
                    }
                    default: {
                        GradleInvoker.addAfterSyncTasks(tasks, gradlePath, properties);
                        GradleInvoker.addAfterSyncTasksForTestArtifacts(tasks, gradlePath, testCompileType, androidGradleModel);
                        if (testCompileType != TestCompileType.JAVA_TESTS) {
                            GradleInvoker.addTaskIfSpecified(tasks, gradlePath, properties.COMPILE_JAVA_TASK_NAME);
                        }
                        for (BaseArtifact artifact : GradleInvoker.getArtifactsForTestCompileType(testCompileType, androidGradleModel)) {
                            GradleInvoker.addTaskIfSpecified(tasks, gradlePath, artifact.getCompileTaskName());
                        }
                        break block18;
                    }
                }
                break block18;
            }
            JavaGradleFacet javaFacet = JavaGradleFacet.getInstance(module);
            if (javaFacet != null && ((JavaGradleFacetConfiguration)javaFacet.getConfiguration()).BUILDABLE) {
                String gradleTaskName = javaFacet.getGradleTaskName(buildMode);
                if (gradleTaskName != null) {
                    tasks.add(GradleInvoker.createBuildTask(gradlePath, gradleTaskName));
                }
                if (testCompileType == TestCompileType.JAVA_TESTS) {
                    tasks.add(GradleInvoker.createBuildTask(gradlePath, "testClasses"));
                }
            }
        }
    }

    private static void addAfterSyncTasksForTestArtifacts(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull TestCompileType testCompileType, @Nullable AndroidGradleModel androidGradleModel) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterSyncTasksForTestArtifacts"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterSyncTasksForTestArtifacts"));
        }
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterSyncTasksForTestArtifacts"));
        }
        Collection<BaseArtifact> testArtifacts = GradleInvoker.getArtifactsForTestCompileType(testCompileType, androidGradleModel);
        for (BaseArtifact artifact : testArtifacts) {
            for (String taskName : AndroidGradleModel.getIdeSetupTasks(artifact)) {
                GradleInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
            }
        }
    }

    @NotNull
    private static Collection<BaseArtifact> getArtifactsForTestCompileType(@NotNull TestCompileType testCompileType, @Nullable AndroidGradleModel androidGradleModel) {
        if (testCompileType == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "testCompileType", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getArtifactsForTestCompileType"));
        }
        if (androidGradleModel == null) {
            List<BaseArtifact> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getArtifactsForTestCompileType"));
            }
            return list;
        }
        AndroidArtifact testArtifact = null;
        switch (testCompileType) {
            case NONE: {
                Collection<BaseArtifact> collection = androidGradleModel.getTestArtifactsInSelectedVariant();
                if (collection == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getArtifactsForTestCompileType"));
                }
                return collection;
            }
            case ANDROID_TESTS: {
                testArtifact = androidGradleModel.getAndroidTestArtifactInSelectedVariant();
                break;
            }
            case JAVA_TESTS: {
                testArtifact = androidGradleModel.getUnitTestArtifactInSelectedVariant();
            }
        }
        ImmutableList immutableList = testArtifact != null ? ImmutableList.of((Object)testArtifact) : Collections.emptyList();
        if (immutableList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getArtifactsForTestCompileType"));
        }
        return immutableList;
    }

    private static void addAfterSyncTasks(@NotNull List<String> tasks, @NotNull String gradlePath, @NotNull JpsAndroidModuleProperties properties) {
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterSyncTasks"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterSyncTasks"));
        }
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "properties", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addAfterSyncTasks"));
        }
        for (String taskName : properties.AFTER_SYNC_TASK_NAMES) {
            GradleInvoker.addTaskIfSpecified(tasks, gradlePath, taskName);
        }
    }

    private static void addTaskIfSpecified(@NotNull List<String> tasks, @NotNull String gradlePath, @Nullable String gradleTaskName) {
        String buildTask;
        if (tasks == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tasks", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addTaskIfSpecified"));
        }
        if (gradlePath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradlePath", "com/android/tools/idea/gradle/invoker/GradleInvoker", "addTaskIfSpecified"));
        }
        if (StringUtil.isNotEmpty((String)gradleTaskName) && !tasks.contains(buildTask = GradleInvoker.createBuildTask(gradlePath, gradleTaskName))) {
            tasks.add(buildTask);
        }
    }

    @NotNull
    public static String createBuildTask(@NotNull String gradleProjectPath, @NotNull String taskName) {
        if (gradleProjectPath == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "gradleProjectPath", "com/android/tools/idea/gradle/invoker/GradleInvoker", "createBuildTask"));
        }
        if (taskName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "taskName", "com/android/tools/idea/gradle/invoker/GradleInvoker", "createBuildTask"));
        }
        if (gradleProjectPath.equals(":")) {
            String string = gradleProjectPath + taskName;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "createBuildTask"));
            }
            return string;
        }
        String string = gradleProjectPath + ":" + taskName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "createBuildTask"));
        }
        return string;
    }

    @NotNull
    public static TestCompileType getTestCompileType(@Nullable String runConfigurationId) {
        if (runConfigurationId != null) {
            if (AndroidCommonUtils.isInstrumentationTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.ANDROID_TESTS;
                if (testCompileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getTestCompileType"));
                }
                return testCompileType;
            }
            if (AndroidCommonUtils.isTestConfiguration((String)runConfigurationId)) {
                TestCompileType testCompileType = TestCompileType.JAVA_TESTS;
                if (testCompileType == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getTestCompileType"));
                }
                return testCompileType;
            }
        }
        TestCompileType testCompileType = TestCompileType.NONE;
        if (testCompileType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/invoker/GradleInvoker", "getTestCompileType"));
        }
        return testCompileType;
    }

    public void cancelTask(@NotNull ExternalSystemTaskId id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/android/tools/idea/gradle/invoker/GradleInvoker", "cancelTask"));
        }
        CancellationTokenSource token = this.myCancellationMap.remove(id);
        if (token != null) {
            token.cancel();
        }
    }

    public static interface AfterGradleInvocationTask {
        public void execute(@NotNull GradleInvocationResult var1);
    }

    @VisibleForTesting
    static interface BeforeGradleInvocationTask {
        public void execute(@NotNull List<String> var1);
    }

    public static enum TestCompileType {
        NONE,
        ANDROID_TESTS,
        JAVA_TESTS;

    }
}

