/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.repository.api.Downloader;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RemotePackage;
import com.android.repository.api.RepoManager;
import com.android.repository.api.SettingsController;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.project.GradleProjectImporter;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.NotificationHyperlink;
import com.android.tools.idea.sdk.StudioDownloader;
import com.android.tools.idea.sdk.StudioSettingsController;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.sdk.wizard.SdkQuickfixUtils;
import com.android.tools.idea.wizard.model.ModelWizardDialog;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class MissingCMakeErrorHandler
extends AbstractSyncErrorHandler {
    private final AndroidSdkHandler mySdkHandler;
    private final Downloader myDownloader;
    private final SettingsController mySettingsController;

    public MissingCMakeErrorHandler() {
        this(null, new StudioDownloader(), StudioSettingsController.getInstance());
    }

    @VisibleForTesting
    MissingCMakeErrorHandler(AndroidSdkHandler sdkHandler, Downloader downloader, SettingsController settingsController) {
        this.mySdkHandler = sdkHandler;
        this.myDownloader = downloader;
        this.mySettingsController = settingsController;
    }

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/MissingCMakeErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/MissingCMakeErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/MissingCMakeErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/MissingCMakeErrorHandler", "handleError"));
        }
        String firstLine = message.get(0);
        if (!firstLine.startsWith("Failed to find CMake.")) {
            return false;
        }
        AndroidSdkHandler sdkHandler = this.mySdkHandler;
        if (sdkHandler == null) {
            sdkHandler = AndroidSdkUtils.tryToChooseSdkHandler();
        }
        StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
        sdkHandler.getSdkManager((ProgressIndicator)progress).loadSynchronously(RepoManager.DEFAULT_EXPIRATION_PERIOD_MS, (ProgressIndicator)progress, this.myDownloader, this.mySettingsController);
        RemotePackage cmakePackage = sdkHandler.getLatestRemotePackageForPrefix("cmake", false, (ProgressIndicator)progress);
        if (cmakePackage == null) {
            return false;
        }
        ArrayList hyperlinks = Lists.newArrayList();
        NotificationHyperlink installCMakeLink = MissingCMakeErrorHandler.getInstallCMakeNotificationHyperlink(cmakePackage.getPath());
        hyperlinks.add(installCMakeLink);
        MissingCMakeErrorHandler.updateNotification(notification, project, "Failed to find CMake.", hyperlinks);
        return true;
    }

    private static NotificationHyperlink getInstallCMakeNotificationHyperlink(final String cmakePackagePath) {
        return new NotificationHyperlink("install.cmake", "Install CMake and sync project"){

            @Override
            protected void execute(@NotNull Project project) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/MissingCMakeErrorHandler$1", "execute"));
                }
                ModelWizardDialog dialog = SdkQuickfixUtils.createDialogForPaths(project, (Collection<String>)ImmutableList.of((Object)cmakePackagePath));
                if (dialog != null && dialog.showAndGet()) {
                    GradleProjectImporter.getInstance().requestProjectSync(project, null);
                }
            }
        };
    }
}

