/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.ide.common.repository.GradleVersion;
import com.android.tools.idea.gradle.dsl.model.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.ArtifactDependencyModel;
import com.android.tools.idea.gradle.dsl.model.dependencies.DependenciesModel;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.UpgradeAppenginePluginVersionHyperlink;
import com.android.tools.idea.gradle.service.repo.ExternalRepository;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Processor;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class OutdatedAppEngineGradlePluginErrorHandler
extends AbstractSyncErrorHandler {
    public static final String MARKER_TEXT = "Cause: java.io.File cannot be cast to org.gradle.api.artifacts.Configuration";

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, final @NotNull NotificationData notification, final @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/OutdatedAppEngineGradlePluginErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/OutdatedAppEngineGradlePluginErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/OutdatedAppEngineGradlePluginErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/OutdatedAppEngineGradlePluginErrorHandler", "handleError"));
        }
        if (!message.contains(MARKER_TEXT)) {
            return false;
        }
        VirtualFile baseDir = project.getBaseDir();
        if (baseDir == null) {
            return false;
        }
        final Ref handled = new Ref((Object)false);
        GradleUtil.processBuildModelsRecursively(project, new Processor<GradleBuildModel>(){

            public boolean process(GradleBuildModel buildModel) {
                DependenciesModel dependencies = buildModel.buildscript().dependencies();
                for (ArtifactDependencyModel dependency : dependencies.artifacts("classpath")) {
                    GradleVersion currentVersion;
                    String version;
                    if (!"com.google.appengine".equals(dependency.group().value()) || !"gradle-appengine-plugin".equals(dependency.name().value()) || (version = dependency.version().value()) == null || (currentVersion = GradleVersion.tryParse((String)version)) == null || currentVersion.compareTo(UpgradeAppenginePluginVersionHyperlink.DEFAULT_APPENGINE_PLUGIN_VERSION) >= 0) continue;
                    ((ExternalRepository)ServiceManager.getService(ExternalRepository.class)).refreshFor("com.google.appengine", "gradle-appengine-plugin");
                    UpgradeAppenginePluginVersionHyperlink quickFix = new UpgradeAppenginePluginVersionHyperlink(dependency, buildModel);
                    AbstractSyncErrorHandler.updateNotification(notification, project, notification.getMessage(), quickFix);
                    handled.set((Object)true);
                    return false;
                }
                return true;
            }
        });
        return (Boolean)handled.get();
    }
}

