/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.service.notification.errors;

import com.android.repository.Revision;
import com.android.repository.api.LocalPackage;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.impl.meta.RepositoryPackages;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.gradle.service.notification.errors.AbstractSyncErrorHandler;
import com.android.tools.idea.gradle.service.notification.hyperlink.FixBuildToolsVersionHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.InstallBuildToolsHyperlink;
import com.android.tools.idea.gradle.service.notification.hyperlink.OpenFileHyperlink;
import com.android.tools.idea.gradle.util.GradleUtil;
import com.android.tools.idea.sdk.progress.StudioLoggerProgressIndicator;
import com.google.common.collect.Lists;
import com.intellij.openapi.externalSystem.model.ExternalSystemException;
import com.intellij.openapi.externalSystem.service.notification.NotificationData;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.android.sdk.AndroidSdkData;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;

public class SdkBuildToolsTooLowErrorHandler
extends AbstractSyncErrorHandler {
    private static final Pattern SDK_BUILD_TOOLS_TOO_LOW_PATTERN = Pattern.compile("The SDK Build Tools revision \\((.*)\\) is too low for project '(.*)'. Minimum required is (.*)");

    @Override
    public boolean handleError(@NotNull List<String> message, @NotNull ExternalSystemException error, @NotNull NotificationData notification, @NotNull Project project) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/android/tools/idea/gradle/service/notification/errors/SdkBuildToolsTooLowErrorHandler", "handleError"));
        }
        if (error == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "error", "com/android/tools/idea/gradle/service/notification/errors/SdkBuildToolsTooLowErrorHandler", "handleError"));
        }
        if (notification == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "notification", "com/android/tools/idea/gradle/service/notification/errors/SdkBuildToolsTooLowErrorHandler", "handleError"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/android/tools/idea/gradle/service/notification/errors/SdkBuildToolsTooLowErrorHandler", "handleError"));
        }
        String firstLine = message.get(0);
        Matcher matcher = SDK_BUILD_TOOLS_TOO_LOW_PATTERN.matcher(firstLine);
        if (matcher.matches()) {
            String gradlePath;
            Module module;
            boolean buildToolInstalled = false;
            String minimumVersion = matcher.group(3);
            AndroidSdkHandler sdkHandler = null;
            AndroidSdkData androidSdkData = AndroidSdkUtils.tryToChooseAndroidSdk();
            if (androidSdkData != null) {
                sdkHandler = androidSdkData.getSdkHandler();
            }
            if (sdkHandler != null) {
                StudioLoggerProgressIndicator progress = new StudioLoggerProgressIndicator(this.getClass());
                RepositoryPackages packages = sdkHandler.getSdkManager((ProgressIndicator)progress).getPackages();
                LocalPackage buildTool = (LocalPackage)packages.getLocalPackages().get(DetailsTypes.getBuildToolsPath((Revision)Revision.parseRevision((String)minimumVersion)));
                boolean bl = buildToolInstalled = buildTool != null;
            }
            if ((module = GradleUtil.findModuleByGradlePath(project, gradlePath = matcher.group(2))) != null) {
                VirtualFile buildFile = GradleUtil.getGradleBuildFile(module);
                ArrayList hyperlinks = Lists.newArrayList();
                if (!buildToolInstalled) {
                    hyperlinks.add(new InstallBuildToolsHyperlink(minimumVersion, buildFile));
                } else if (buildFile != null) {
                    hyperlinks.add(new FixBuildToolsVersionHyperlink(buildFile, minimumVersion));
                }
                if (buildFile != null) {
                    hyperlinks.add(new OpenFileHyperlink(buildFile.getPath()));
                }
                if (!hyperlinks.isEmpty()) {
                    SdkBuildToolsTooLowErrorHandler.updateNotification(notification, project, error.getMessage(), hyperlinks);
                    return true;
                }
            }
        }
        return false;
    }
}

