/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables;

import com.android.tools.idea.gradle.structure.configurables.BaseNamedConfigurable;
import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesByTypeAndTextComparator;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsIssueCollection;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.Comparator;
import java.util.List;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;

public class PsModuleCellRenderer
extends ColoredTreeCellRenderer {
    @NotNull
    private final PsContext myContext;

    public PsModuleCellRenderer(@NotNull PsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/PsModuleCellRenderer", "<init>"));
        }
        this.myContext = context;
    }

    public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/android/tools/idea/gradle/structure/configurables/PsModuleCellRenderer", "customizeCellRenderer"));
        }
        if (value instanceof MasterDetailsComponent.MyNode) {
            MasterDetailsComponent.MyNode node = (MasterDetailsComponent.MyNode)value;
            NamedConfigurable namedConfigurable = node.getConfigurable();
            if (namedConfigurable == null) {
                return;
            }
            this.setIcon(namedConfigurable.getIcon(expanded));
            this.setToolTipText(null);
            this.setFont(UIUtil.getTreeFont());
            SimpleTextAttributes textAttributes = SimpleTextAttributes.REGULAR_ATTRIBUTES;
            if (node.isDisplayInBold()) {
                textAttributes = SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES;
            } else if (namedConfigurable instanceof BaseNamedConfigurable) {
                Object module = ((BaseNamedConfigurable)namedConfigurable).getEditableObject();
                List<PsIssue> issues = this.myContext.getAnalyzerDaemon().getIssues().findIssues((PsModel)module, (Comparator<PsIssue>)IssuesByTypeAndTextComparator.INSTANCE);
                this.setToolTipText(PsIssueCollection.getTooltipText(issues, true));
                if (!issues.isEmpty()) {
                    PsIssue issue = issues.get(0);
                    Color waveColor = issue.getSeverity().getColor();
                    textAttributes = textAttributes.derive(8, null, null, waveColor);
                }
            }
            this.append(node.getDisplayName(), textAttributes);
        }
    }
}

