/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.module;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.AbstractMainDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.DeclaredDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.module.ResolvedDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.PsUISettings;
import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidModule;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MainPanel
extends AbstractMainDependenciesPanel {
    @NotNull
    private final JBSplitter myVerticalSplitter;
    @NotNull
    private final DeclaredDependenciesPanel myDeclaredDependenciesPanel;
    @NotNull
    private final ResolvedDependenciesPanel myResolvedDependenciesPanel;
    @NotNull
    private final JPanel myAltPanel;

    MainPanel(@NotNull PsAndroidModule module, @NotNull PsContext context, @NotNull List<PsModule> extraTopModules) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/MainPanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/MainPanel", "<init>"));
        }
        if (extraTopModules == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extraTopModules", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/MainPanel", "<init>"));
        }
        super(context, extraTopModules);
        this.myDeclaredDependenciesPanel = new DeclaredDependenciesPanel(module, context);
        this.myDeclaredDependenciesPanel.setHistory(this.getHistory());
        this.myResolvedDependenciesPanel = new ResolvedDependenciesPanel(module, context, this.myDeclaredDependenciesPanel);
        this.myVerticalSplitter = this.createMainVerticalSplitter();
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myDeclaredDependenciesPanel);
        this.myVerticalSplitter.setSecondComponent((JComponent)this.myResolvedDependenciesPanel);
        this.add((Component)this.myVerticalSplitter, "Center");
        this.myDeclaredDependenciesPanel.updateTableColumnSizes();
        this.myDeclaredDependenciesPanel.add(this.myResolvedDependenciesPanel::setSelection);
        this.myResolvedDependenciesPanel.add(this.myDeclaredDependenciesPanel::setSelection);
        JPanel minimizedContainerPanel = this.myResolvedDependenciesPanel.getMinimizedPanel();
        assert (minimizedContainerPanel != null);
        this.myAltPanel = new JPanel(new BorderLayout());
        this.myAltPanel.add((Component)minimizedContainerPanel, "East");
        ToolWindowHeader header = this.myResolvedDependenciesPanel.getHeader();
        header.addMinimizeListener(this::minimizeResolvedDependenciesPanel);
        this.myResolvedDependenciesPanel.addRestoreListener(this::restoreResolvedDependenciesPanel);
    }

    private void restoreResolvedDependenciesPanel() {
        this.remove(this.myAltPanel);
        this.myAltPanel.remove(this.myDeclaredDependenciesPanel);
        this.myVerticalSplitter.setFirstComponent((JComponent)this.myDeclaredDependenciesPanel);
        this.add((Component)this.myVerticalSplitter, "Center");
        UiUtil.revalidateAndRepaint(this);
        MainPanel.saveMinimizedState(false);
    }

    private void minimizeResolvedDependenciesPanel() {
        this.remove((Component)this.myVerticalSplitter);
        this.myVerticalSplitter.setFirstComponent(null);
        this.myAltPanel.add((Component)this.myDeclaredDependenciesPanel, "Center");
        this.add((Component)this.myAltPanel, "Center");
        UiUtil.revalidateAndRepaint(this);
        MainPanel.saveMinimizedState(true);
    }

    private static void saveMinimizedState(boolean minimize) {
        PsUISettings.getInstance().RESOLVED_DEPENDENCIES_MINIMIZE = minimize;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        boolean minimize = PsUISettings.getInstance().RESOLVED_DEPENDENCIES_MINIMIZE;
        if (minimize) {
            this.minimizeResolvedDependenciesPanel();
        } else {
            this.restoreResolvedDependenciesPanel();
        }
    }

    @Override
    public void setHistory(History history) {
        super.setHistory(history);
        this.myDeclaredDependenciesPanel.setHistory(history);
    }

    public void putPath(@NotNull Place place, @NotNull String dependency) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/MainPanel", "putPath"));
        }
        if (dependency == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dependency", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/MainPanel", "putPath"));
        }
        this.myDeclaredDependenciesPanel.putPath(place, dependency);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return this.myDeclaredDependenciesPanel.navigateTo(place, requestFocus);
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "place", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/module/MainPanel", "queryPlace"));
        }
        this.myDeclaredDependenciesPanel.queryPlace(place);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDeclaredDependenciesPanel);
        Disposer.dispose((Disposable)this.myResolvedDependenciesPanel);
    }
}

