/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.android.dependencies.project;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.ModuleDependencyDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.details.MultipleLibraryDependenciesDetails;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.AbstractPsNodeTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.GoToModuleAction;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.LibraryDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.ModuleDependencyNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.SelectNodesMatchingCurrentSelectionAction;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.graph.DependenciesTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.graph.DependenciesTreeRootNode;
import com.android.tools.idea.gradle.structure.configurables.android.dependencies.treeview.graph.DependenciesTreeStructure;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesRenderer;
import com.android.tools.idea.gradle.structure.configurables.issues.IssuesViewer;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeEventDispatcher;
import com.android.tools.idea.gradle.structure.configurables.ui.SelectionChangeListener;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDependenciesPanel;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseCollapseAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseExpandAllAction;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsModelNode;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.NodeHyperlinkSupport;
import com.android.tools.idea.gradle.structure.model.PsArtifactDependencySpec;
import com.android.tools.idea.gradle.structure.model.PsModule;
import com.android.tools.idea.gradle.structure.model.PsProject;
import com.android.tools.idea.gradle.structure.model.android.PsAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsLibraryAndroidDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionPopupMenu;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.navigation.Place;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DependencyGraphPanel
extends AbstractDependenciesPanel {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final DependenciesTreeBuilder myTreeBuilder;
    @NotNull
    private final NodeHyperlinkSupport<ModuleDependencyNode> myHyperlinkSupport;
    @NotNull
    private final SelectionChangeEventDispatcher<List<AbstractDependencyNode<? extends PsAndroidDependency>>> myEventDispatcher;
    private boolean myIgnoreTreeSelectionEvents;

    DependencyGraphPanel(@NotNull PsModule fakeModule, @NotNull PsContext context) {
        if (fakeModule == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeModule", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "<init>"));
        }
        super("All Dependencies", context, null);
        this.myEventDispatcher = new SelectionChangeEventDispatcher();
        this.myContext = context;
        this.initializeDependencyDetails();
        this.setIssuesViewer(new IssuesViewer(this.myContext, new IssuesRenderer()));
        DefaultTreeModel treeModel = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree(treeModel){

            protected void processMouseEvent(MouseEvent e) {
                ModuleDependencyNode node;
                int id = e.getID();
                if (id == 501 && (node = (ModuleDependencyNode)((Object)DependencyGraphPanel.this.myHyperlinkSupport.getIfHyperlink(e))) != null) {
                    PsModuleAndroidDependency moduleDependency = (PsModuleAndroidDependency)node.getFirstModel();
                    String name = moduleDependency.getName();
                    DependencyGraphPanel.this.myContext.setSelectedModule(name, DependencyGraphPanel.this);
                    return;
                }
                super.processMouseEvent(e);
            }
        };
        this.getContentsPanel().add((Component)this.createActionsPanel(), "North");
        DependenciesTreeStructure treeStructure = new DependenciesTreeStructure(this.createRootNode());
        this.myTreeBuilder = new DependenciesTreeBuilder((JTree)this.myTree, treeModel, treeStructure);
        JScrollPane scrollPane = UiUtil.setUp(this.myTreeBuilder);
        this.getContentsPanel().add((Component)scrollPane, "Center");
        TreeSelectionListener treeSelectionListener = e -> {
            if (!this.myIgnoreTreeSelectionEvents) {
                PsAndroidDependency selected;
                final List<AbstractDependencyNode<? extends PsAndroidDependency>> selection = this.getMatchingSelection();
                PsAndroidDependency psAndroidDependency = selected = !selection.isEmpty() ? (PsAndroidDependency)selection.get(0).getFirstModel() : null;
                if (selected == null) {
                    this.notifySelectionChanged(Collections.emptyList());
                } else {
                    final NodeSelectionDetector detector = new NodeSelectionDetector();
                    this.myTreeBuilder.collectNodesMatchingCurrentSelection(selected, new AbstractPsNodeTreeBuilder.MatchingNodeCollector(){

                        @Override
                        protected void done(@NotNull List<AbstractPsModelNode> matchingNodes) {
                            if (matchingNodes == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "matchingNodes", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel$2", "done"));
                            }
                            matchingNodes.forEach(detector::add);
                            List<Object> singleSelection = Collections.emptyList();
                            if (!selection.isEmpty()) {
                                singleSelection = detector.getSingleTypeSelection();
                            }
                            DependencyGraphPanel.this.notifySelectionChanged(singleSelection);
                        }
                    });
                }
                this.updateDetails(selected);
                this.updateIssues(selection);
            }
            this.myIgnoreTreeSelectionEvents = false;
        };
        this.myTree.addTreeSelectionListener(treeSelectionListener);
        this.myTree.addMouseListener((MouseListener)new PopupHandler(){

            public void invokePopup(Component comp, int x, int y) {
                DependencyGraphPanel.this.popupInvoked(x, y);
            }
        });
        this.myTreeBuilder.getInitialized().doWhenDone(this::doEnsureSelection);
        this.myHyperlinkSupport = new NodeHyperlinkSupport<ModuleDependencyNode>(this.myTree, ModuleDependencyNode.class, this.myContext, true);
        PsModule.DependenciesChangeListener dependenciesChangeListener = event -> {
            if (fakeModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fakeModule", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "lambda$new$2"));
            }
            fakeModule.setModified(true);
            if (event instanceof PsModule.LibraryDependencyAddedEvent) {
                PsArtifactDependencySpec spec = ((PsModule.LibraryDependencyAddedEvent)event).getSpec();
                this.myTreeBuilder.reset(() -> {
                    LibraryDependencyNode found = this.myTreeBuilder.find(spec);
                    if (found != null) {
                        this.myTreeBuilder.select((Object)found);
                    }
                });
            } else if (event != null) {
                this.myTreeBuilder.reset(null);
            }
        };
        this.myContext.getProject().forEachModule(module -> module.add(dependenciesChangeListener, this));
    }

    @NotNull
    private DependenciesTreeRootNode<PsProject> createRootNode() {
        DependenciesTreeRootNode<PsProject> dependenciesTreeRootNode = new DependenciesTreeRootNode<PsProject>(this.myContext.getProject(), new DependenciesTreeRootNode.DependencyCollectorFunction<PsProject>(){

            @Override
            public DependenciesTreeRootNode.DependencyCollector apply(PsProject project) {
                DependenciesTreeRootNode.DependencyCollector collector = new DependenciesTreeRootNode.DependencyCollector();
                project.forEachModule(module -> this.collectDeclaredDependencies((PsModule)module, collector));
                return collector;
            }
        });
        if (dependenciesTreeRootNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "createRootNode"));
        }
        return dependenciesTreeRootNode;
    }

    @NotNull
    private List<AbstractDependencyNode<? extends PsAndroidDependency>> getMatchingSelection() {
        ArrayList selection = Lists.newArrayList();
        List<AbstractDependencyNode> matchingSelection = this.myTreeBuilder.getMatchingSelection(AbstractDependencyNode.class);
        for (AbstractDependencyNode node : matchingSelection) {
            selection.add(node);
        }
        ArrayList arrayList = selection;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "getMatchingSelection"));
        }
        return arrayList;
    }

    private void updateIssues(@NotNull List<AbstractDependencyNode<? extends PsAndroidDependency>> selection) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "updateIssues"));
        }
        ArrayList issues = Lists.newArrayList();
        for (AbstractDependencyNode<? extends PsAndroidDependency> node : selection) {
            for (PsAndroidDependency dependency : node.getModels()) {
                issues.addAll(this.myContext.getAnalyzerDaemon().getIssues().findIssues(dependency, null));
            }
        }
        this.displayIssues(issues);
    }

    private void notifySelectionChanged(@NotNull List<AbstractDependencyNode<? extends PsAndroidDependency>> selected) {
        if (selected == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selected", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "notifySelectionChanged"));
        }
        this.myEventDispatcher.selectionChanged(selected);
    }

    private void popupInvoked(int x, int y) {
        ModuleDependencyNode node = this.myHyperlinkSupport.getNodeForLocation(x, y);
        if (node != null) {
            PsModuleAndroidDependency moduleDependency = (PsModuleAndroidDependency)node.getFirstModel();
            String name = moduleDependency.getName();
            DefaultActionGroup group = new DefaultActionGroup();
            group.add((AnAction)new GoToModuleAction(name, this.getContext(), (JComponent)this.myTree));
            ActionPopupMenu popupMenu = ActionManager.getInstance().createActionPopupMenu("", (ActionGroup)group);
            popupMenu.getComponent().show((Component)this.myTree, x, y);
        }
    }

    private void initializeDependencyDetails() {
        this.addDetails(new MultipleLibraryDependenciesDetails());
        this.addDetails(new ModuleDependencyDetails(this.getContext(), false));
    }

    @Override
    @NotNull
    public JComponent getPreferredFocusedComponent() {
        Tree tree = this.myTree;
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "getPreferredFocusedComponent"));
        }
        return tree;
    }

    void add(@NotNull SelectionChangeListener<List<AbstractDependencyNode<? extends PsAndroidDependency>>> listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "add"));
        }
        this.myEventDispatcher.addListener(listener, this);
    }

    @Override
    @NotNull
    protected List<AnAction> getExtraToolbarActions() {
        ArrayList actions = Lists.newArrayList();
        actions.add(new SelectNodesMatchingCurrentSelectionAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                DependencyGraphPanel.this.myIgnoreTreeSelectionEvents = true;
                super.actionPerformed(e);
            }

            @Override
            @NotNull
            protected AbstractPsNodeTreeBuilder getTreeBuilder() {
                DependenciesTreeBuilder dependenciesTreeBuilder = DependencyGraphPanel.this.myTreeBuilder;
                if (dependenciesTreeBuilder == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel$5", "getTreeBuilder"));
                }
                return dependenciesTreeBuilder;
            }
        });
        actions.add(new Separator());
        actions.add(new AbstractBaseExpandAllAction(this.myTree, AllIcons.Actions.Expandall){

            public void actionPerformed(AnActionEvent e) {
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                DependencyGraphPanel.this.myTreeBuilder.expandAllNodes();
                DependencyGraphPanel.this.doEnsureSelection();
            }
        });
        actions.add(new AbstractBaseCollapseAllAction(this.myTree, AllIcons.Actions.Collapseall){

            public void actionPerformed(AnActionEvent e) {
                DependencyGraphPanel.this.myTreeBuilder.clearSelection();
                DependencyGraphPanel.this.notifySelectionChanged(Collections.emptyList());
                DependencyGraphPanel.this.myTree.requestFocusInWindow();
                DependencyGraphPanel.this.myTreeBuilder.collapseAllNodes();
                DependencyGraphPanel.this.doEnsureSelection();
            }
        });
        ArrayList arrayList = actions;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "getExtraToolbarActions"));
        }
        return arrayList;
    }

    private void doEnsureSelection() {
        TreeUtil.ensureSelection((JTree)this.myTree);
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myTreeBuilder);
        Disposer.dispose(this.myHyperlinkSupport);
    }

    @Override
    public void selectDependency(@Nullable String dependency) {
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean requestFocus) {
        return ActionCallback.DONE;
    }

    @Override
    @NotNull
    protected String getPlaceName() {
        if ("dependencies.graph.project" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel", "getPlaceName"));
        }
        return "dependencies.graph.project";
    }

    private static class NodeSelectionDetector {
        @NotNull
        private final Map<String, List<AbstractDependencyNode<? extends PsAndroidDependency>>> mySelection = Maps.newHashMap();

        private NodeSelectionDetector() {
        }

        void add(@NotNull AbstractPsModelNode node) {
            if (node == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel$NodeSelectionDetector", "add"));
            }
            String key = null;
            if (node instanceof ModuleDependencyNode) {
                key = ((PsModuleAndroidDependency)((ModuleDependencyNode)node).getFirstModel()).getGradlePath();
            }
            if (node instanceof LibraryDependencyNode) {
                key = ((PsLibraryAndroidDependency)((LibraryDependencyNode)node).getFirstModel()).getResolvedSpec().toString();
            }
            if (key != null) {
                ArrayList nodes = this.mySelection.get(key);
                if (nodes == null) {
                    nodes = Lists.newArrayList();
                    this.mySelection.put(key, nodes);
                }
                nodes.add((AbstractDependencyNode)node);
            }
        }

        @NotNull
        List<AbstractDependencyNode<? extends PsAndroidDependency>> getSingleTypeSelection() {
            Set<String> keys = this.mySelection.keySet();
            if (keys.size() == 1) {
                List<AbstractDependencyNode<? extends PsAndroidDependency>> list = this.mySelection.get(ContainerUtil.getFirstItem(keys));
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel$NodeSelectionDetector", "getSingleTypeSelection"));
                }
                return list;
            }
            List<AbstractDependencyNode<? extends PsAndroidDependency>> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/android/dependencies/project/DependencyGraphPanel$NodeSelectionDetector", "getSingleTypeSelection"));
            }
            return list;
        }
    }
}

