/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.issues;

import com.android.tools.idea.gradle.structure.configurables.issues.IssuesRenderer;
import com.android.tools.idea.gradle.structure.model.PsIssue;
import com.android.tools.idea.gradle.structure.model.PsPath;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class SingleModuleIssuesRenderer
extends IssuesRenderer {
    @Override
    @NotNull
    public String render(@NotNull Collection<PsIssue> issues) {
        if (issues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "issues", "com/android/tools/idea/gradle/structure/configurables/issues/SingleModuleIssuesRenderer", "render"));
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append("<html><body><ol>");
        for (PsIssue issue : issues) {
            String description;
            buffer.append("<li>").append(issue.getText());
            PsPath quickFixPath = issue.getQuickFixPath();
            if (quickFixPath != null) {
                buffer.append(" ").append(quickFixPath.toText(PsPath.TexType.HTML));
            }
            if (StringUtil.isNotEmpty((String)(description = issue.getDescription()))) {
                buffer.append("<br/><br/>").append(description);
            }
            buffer.append("</li>");
        }
        buffer.append("</ol></body></html>");
        String string = buffer.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/issues/SingleModuleIssuesRenderer", "render"));
        }
        return string;
    }
}

