/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.ToolWindowHeader;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.impl.AnchoredButton;
import com.intellij.openapi.wm.impl.StripeButtonUI;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.EventListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ToolWindowPanel
extends JPanel
implements Disposable {
    @NotNull
    private final ToolWindowHeader myHeader;
    @NotNull
    private final EventDispatcher<RestoreListener> myEventDispatcher;
    private JPanel myMinimizedPanel;
    private AnchoredToolWindowButton myAnchoredButton;

    protected ToolWindowPanel(@NotNull String title, @NotNull Icon icon, @Nullable ToolWindowAnchor anchor) {
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel", "<init>"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel", "<init>"));
        }
        super(new BorderLayout());
        this.myEventDispatcher = EventDispatcher.create(RestoreListener.class);
        this.myHeader = ToolWindowHeader.createAndAdd(title, icon, this, anchor);
        if (anchor != null) {
            this.myAnchoredButton = new AnchoredToolWindowButton(this.myHeader, anchor);
            this.myAnchoredButton.addActionListener(e -> {
                this.myAnchoredButton.setSelected(false);
                ((RestoreListener)this.myEventDispatcher.getMulticaster()).restored();
            });
            this.myMinimizedPanel = new MinimizedContainerPanel(this.myAnchoredButton);
        }
    }

    public void addRestoreListener(@NotNull RestoreListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel", "addRestoreListener"));
        }
        this.myEventDispatcher.addListener((EventListener)listener, (Disposable)this);
    }

    @Nullable
    public JPanel getMinimizedPanel() {
        return this.myMinimizedPanel;
    }

    @NotNull
    public ToolWindowHeader getHeader() {
        ToolWindowHeader toolWindowHeader = this.myHeader;
        if (toolWindowHeader == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel", "getHeader"));
        }
        return toolWindowHeader;
    }

    @Nullable
    public ToolWindowAnchor getAnchor() {
        return this.myAnchoredButton != null ? this.myAnchoredButton.getAnchor() : null;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myHeader);
    }

    private static class AnchoredToolWindowButton
    extends AnchoredButton {
        @NotNull
        private final ToolWindowAnchor myAnchor;

        AnchoredToolWindowButton(@NotNull ToolWindowHeader header, @NotNull ToolWindowAnchor anchor) {
            if (header == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "header", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel$AnchoredToolWindowButton", "<init>"));
            }
            if (anchor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchor", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel$AnchoredToolWindowButton", "<init>"));
            }
            super(header.getTitle(), header.getIcon());
            this.myAnchor = anchor;
            this.setBorder(BorderFactory.createEmptyBorder());
            this.setFocusable(false);
            this.setRolloverEnabled(true);
            this.setOpaque(false);
        }

        public void updateUI() {
            this.setUI(StripeButtonUI.createUI((JComponent)((Object)this)));
            this.setFont(UIUtil.getLabelFont((UIUtil.FontSize)UIUtil.FontSize.SMALL));
        }

        public int getMnemonic2() {
            return 0;
        }

        @NotNull
        public ToolWindowAnchor getAnchor() {
            ToolWindowAnchor toolWindowAnchor = this.myAnchor;
            if (toolWindowAnchor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel$AnchoredToolWindowButton", "getAnchor"));
            }
            return toolWindowAnchor;
        }
    }

    private static class MinimizedContainerPanel
    extends JPanel {
        @NotNull
        private final AnchoredToolWindowButton myAnchoredButton;

        MinimizedContainerPanel(@NotNull AnchoredToolWindowButton anchoredButton) {
            if (anchoredButton == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "anchoredButton", "com/android/tools/idea/gradle/structure/configurables/ui/ToolWindowPanel$MinimizedContainerPanel", "<init>"));
            }
            this.myAnchoredButton = anchoredButton;
            this.configureBorder();
            this.add((Component)((Object)this.myAnchoredButton));
        }

        private void configureBorder() {
            int borderStyle;
            ToolWindowAnchor anchor = this.myAnchoredButton.getAnchor();
            if (anchor == ToolWindowAnchor.LEFT) {
                borderStyle = 4;
            } else if (anchor == ToolWindowAnchor.RIGHT) {
                borderStyle = 1;
            } else if (anchor == ToolWindowAnchor.BOTTOM) {
                borderStyle = 2;
            } else {
                return;
            }
            this.setBorder(IdeBorderFactory.createBorder((int)borderStyle));
        }

        @Override
        public void doLayout() {
            Dimension size = this.myAnchoredButton.getPreferredSize();
            if (this.myAnchoredButton.getAnchor() == ToolWindowAnchor.BOTTOM) {
                this.myAnchoredButton.setBounds(0, 1, size.width, 25);
            } else {
                this.myAnchoredButton.setBounds(0, 0, this.getWidth(), size.height);
            }
        }
    }

    public static interface RestoreListener
    extends EventListener {
        public void restored();
    }
}

