/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractBaseTreeBuilder;
import com.android.tools.idea.gradle.structure.configurables.ui.treeview.TreeBuilderSpeedSearch;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.util.BitUtil;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.TreeSelectionModel;
import org.jetbrains.annotations.NotNull;

public final class UiUtil {
    private UiUtil() {
    }

    public static void revalidateAndRepaint(@NotNull JComponent c) {
        if (c == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/android/tools/idea/gradle/structure/configurables/ui/UiUtil", "revalidateAndRepaint"));
        }
        c.doLayout();
        c.revalidate();
        c.repaint();
    }

    @NotNull
    public static JScrollPane setUp(@NotNull AbstractBaseTreeBuilder treeBuilder) {
        if (treeBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeBuilder", "com/android/tools/idea/gradle/structure/configurables/ui/UiUtil", "setUp"));
        }
        JTree tree = treeBuilder.getUi().getTree();
        tree.setExpandsSelectedPaths(true);
        tree.setRootVisible(false);
        TreeSelectionModel selectionModel = tree.getSelectionModel();
        selectionModel.setSelectionMode(4);
        TreeBuilderSpeedSearch.installTo(treeBuilder);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)tree);
        scrollPane.setBorder(IdeBorderFactory.createEmptyBorder());
        JScrollPane jScrollPane = scrollPane;
        if (jScrollPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/UiUtil", "setUp"));
        }
        return jScrollPane;
    }

    public static boolean isMetaOrCtrlKeyPressed(@NotNull KeyEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/ui/UiUtil", "isMetaOrCtrlKeyPressed"));
        }
        return e.getKeyCode() == (SystemInfo.isMac ? 157 : 17);
    }

    public static boolean isMetaOrCtrlKeyPressed(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/ui/UiUtil", "isMetaOrCtrlKeyPressed"));
        }
        int modifiers = e.getModifiers();
        return BitUtil.isSet((int)modifiers, (int)(SystemInfo.isMac ? 4 : 2));
    }
}

