/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.dependencies;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.android.tools.idea.gradle.structure.configurables.ui.UiUtil;
import com.android.tools.idea.gradle.structure.configurables.ui.dependencies.AbstractDeclaredDependenciesTableModel;
import com.android.tools.idea.gradle.structure.model.PsDependency;
import com.android.tools.idea.gradle.structure.model.PsModuleDependency;
import com.android.tools.idea.gradle.structure.model.android.PsModuleAndroidDependency;
import com.intellij.openapi.Disposable;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.table.TableView;
import com.intellij.util.containers.ContainerUtil;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.MouseInfo;
import java.awt.Point;
import java.awt.PointerInfo;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeclaredDependenciesTableView<T extends PsDependency>
extends TableView<T>
implements Disposable {
    @NotNull
    private final PsContext myContext;
    private KeyEventDispatcher myKeyEventDispatcher;

    public DeclaredDependenciesTableView(@NotNull AbstractDeclaredDependenciesTableModel<T> model, @NotNull PsContext context) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView", "<init>"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView", "<init>"));
        }
        super(model);
        this.myContext = context;
        this.getSelectionModel().setSelectionMode(2);
        this.addHyperlinkFunctionality();
        this.setDragEnabled(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setShowGrid(false);
        new TableSpeedSearch((JTable)((Object)this), (o, cell) -> {
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView", "lambda$new$0"));
            }
            PsDependency dependency = (PsDependency)model.getItem(cell.getRow());
            if (dependency != null) {
                return AbstractDeclaredDependenciesTableModel.displayTextOf(dependency);
            }
            return o == null || o instanceof Boolean ? "" : o.toString();
        });
    }

    protected void processMouseEvent(MouseEvent e) {
        PsModuleDependency dependency;
        int id = e.getID();
        if (id == 501 && (dependency = this.getIfHyperlink(e)) != null) {
            String name = dependency.getName();
            this.myContext.setSelectedModule(name, (Object)this);
            return;
        }
        super.processMouseEvent(e);
    }

    @Nullable
    private PsModuleDependency getIfHyperlink(@NotNull MouseEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView", "getIfHyperlink"));
        }
        if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
            Point point = new Point(e.getX(), e.getY());
            return this.getDependencyForLocation(point);
        }
        return null;
    }

    private void addHyperlinkFunctionality() {
        this.addMouseMotionListener(new MouseAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                PsModuleDependency hovered = DeclaredDependenciesTableView.this.getIfHyperlink(e);
                DeclaredDependenciesTableView.this.setHoveredDependency(hovered);
            }
        });
        this.myKeyEventDispatcher = e -> {
            PsModuleDependency dependency = null;
            if (e.getID() == 401) {
                if (UiUtil.isMetaOrCtrlKeyPressed(e)) {
                    dependency = this.getDependencyUnderMousePointer();
                }
                this.setHoveredDependency(dependency);
            } else if (e.getID() == 402 && UiUtil.isMetaOrCtrlKeyPressed(e)) {
                this.setHoveredDependency(null);
            }
            return false;
        };
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(this.myKeyEventDispatcher);
    }

    @Nullable
    private PsModuleDependency getDependencyUnderMousePointer() {
        PointerInfo pointerInfo = MouseInfo.getPointerInfo();
        if (pointerInfo != null) {
            Point location = pointerInfo.getLocation();
            SwingUtilities.convertPointFromScreen(location, (Component)((Object)this));
            return this.getDependencyForLocation(location);
        }
        return null;
    }

    @Nullable
    private PsModuleAndroidDependency getDependencyForLocation(@NotNull Point location) {
        PsDependency dependency;
        int row;
        if (location == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "location", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView", "getDependencyForLocation"));
        }
        int column = this.columnAtPoint(location);
        if (column == 0 && (row = this.rowAtPoint(location)) > -1 && (dependency = (PsDependency)this.getListTableModel().getItem(row)) instanceof PsModuleAndroidDependency) {
            return (PsModuleAndroidDependency)dependency;
        }
        return null;
    }

    private void setHoveredDependency(@Nullable PsModuleDependency dependency) {
        this.getListTableModel().setHoveredDependency(dependency);
        Cursor cursor = Cursor.getDefaultCursor();
        if (dependency != null) {
            cursor = Cursor.getPredefinedCursor(12);
        }
        this.setCursor(cursor);
        this.repaint();
    }

    public AbstractDeclaredDependenciesTableModel<T> getListTableModel() {
        return (AbstractDeclaredDependenciesTableModel)((Object)super.getModel());
    }

    public void selectFirstRow() {
        if (!this.getItems().isEmpty()) {
            this.changeSelection(0, 0, false, false);
        }
    }

    @Nullable
    public T getSelectionIfSingle() {
        Collection selection = this.getSelection();
        if (selection.size() == 1) {
            PsDependency selected = (PsDependency)ContainerUtil.getFirstItem((Collection)selection);
            assert (selected != null);
            return (T)selected;
        }
        return null;
    }

    public void selectDependency(@NotNull String toSelect) {
        if (toSelect == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toSelect", "com/android/tools/idea/gradle/structure/configurables/ui/dependencies/DeclaredDependenciesTableView", "selectDependency"));
        }
        this.requestFocusInWindow();
        for (PsDependency dependency : this.getItems()) {
            String dependencyAsText = dependency.toText(PsDependency.TextType.FOR_NAVIGATION);
            if (!toSelect.equals(dependencyAsText)) continue;
            this.setSelection(Collections.singletonList(dependency));
            break;
        }
    }

    public void dispose() {
        if (this.myKeyEventDispatcher != null) {
            KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventDispatcher(this.myKeyEventDispatcher);
        }
    }
}

