/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.configurables.ui.treeview;

import com.android.tools.idea.gradle.structure.configurables.ui.treeview.AbstractPsNode;
import com.android.tools.idea.gradle.structure.model.PsModel;
import com.google.common.collect.Lists;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ui.SimpleTextAttributes;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractPsModelNode<T extends PsModel>
extends AbstractPsNode {
    @NotNull
    private final List<T> myModels;

    @SafeVarargs
    protected AbstractPsModelNode(@NotNull AbstractPsNode parent, T ... models) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "<init>"));
        }
        super(parent);
        this.myModels = Lists.newArrayList((Object[])models);
        this.updateNameAndIcon();
    }

    @SafeVarargs
    protected AbstractPsModelNode(T ... models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "<init>"));
        }
        this.myModels = Lists.newArrayList((Object[])models);
        this.updateNameAndIcon();
    }

    protected AbstractPsModelNode(@NotNull AbstractPsNode parent, @NotNull List<T> models) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "<init>"));
        }
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "<init>"));
        }
        super(parent);
        this.myModels = models;
        this.updateNameAndIcon();
    }

    protected AbstractPsModelNode(@NotNull List<T> models) {
        if (models == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "models", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "<init>"));
        }
        this.myModels = models;
        this.updateNameAndIcon();
    }

    protected void updateNameAndIcon() {
        int modelCount = this.myModels.size();
        if (modelCount != 0) {
            PsModel first = (PsModel)this.myModels.get(0);
            if (modelCount == 1) {
                this.myName = this.nameOf(first);
            } else {
                StringBuilder buffer = new StringBuilder();
                for (int i = 0; i < modelCount; ++i) {
                    PsModel model = (PsModel)this.myModels.get(i);
                    buffer.append(this.nameOf(model));
                    if (i >= modelCount - 1) continue;
                    buffer.append(", ");
                }
                this.myName = buffer.toString();
            }
            this.setIcon(first.getIcon());
        }
    }

    @NotNull
    protected String nameOf(T model) {
        String string = ((PsModel)model).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "nameOf"));
        }
        return string;
    }

    @NotNull
    public List<T> getModels() {
        List<T> list = this.myModels;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "getModels"));
        }
        return list;
    }

    @NotNull
    public T getFirstModel() {
        assert (!this.myModels.isEmpty());
        PsModel psModel = (PsModel)this.myModels.get(0);
        if (psModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "getFirstModel"));
        }
        return (T)psModel;
    }

    public boolean matches(@NotNull PsModel model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/android/tools/idea/gradle/structure/configurables/ui/treeview/AbstractPsModelNode", "matches"));
        }
        for (PsModel m : this.myModels) {
            if (!m.equals(model)) continue;
            return true;
        }
        return false;
    }

    protected void doUpdate() {
        PresentationData presentation = this.getTemplatePresentation();
        presentation.clearText();
        presentation.addText(this.myName, SimpleTextAttributes.REGULAR_ATTRIBUTES);
    }
}

