/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.structure.daemon;

import com.android.tools.idea.gradle.structure.configurables.PsContext;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsDaemon
implements Disposable {
    @NotNull
    private final PsContext myContext;
    @NotNull
    private final AtomicBoolean myStopped;

    protected PsDaemon(@NotNull PsContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/android/tools/idea/gradle/structure/daemon/PsDaemon", "<init>"));
        }
        this.myStopped = new AtomicBoolean(false);
        this.myContext = context;
        Disposer.register((Disposable)context, (Disposable)this);
    }

    @NotNull
    protected final MergingUpdateQueue createQueue(@NotNull String name, @Nullable JComponent modalityStateComponent) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/android/tools/idea/gradle/structure/daemon/PsDaemon", "createQueue"));
        }
        MergingUpdateQueue mergingUpdateQueue = new MergingUpdateQueue(name, 300, false, modalityStateComponent, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        if (mergingUpdateQueue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/PsDaemon", "createQueue"));
        }
        return mergingUpdateQueue;
    }

    public void reset() {
        MergingUpdateQueue mainQueue = this.getMainQueue();
        PsDaemon.reset(mainQueue, this.getResultsUpdaterQueue());
        mainQueue.queue(new Update("reset"){

            public void run() {
                PsDaemon.this.myStopped.set(false);
            }
        });
    }

    private static void reset(MergingUpdateQueue ... queues) {
        if (queues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queues", "com/android/tools/idea/gradle/structure/daemon/PsDaemon", "reset"));
        }
        for (MergingUpdateQueue queue : queues) {
            queue.activate();
        }
    }

    public void stop() {
        this.myStopped.set(true);
        PsDaemon.stop(this.getMainQueue(), this.getResultsUpdaterQueue());
    }

    private static void stop(MergingUpdateQueue ... queues) {
        if (queues == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "queues", "com/android/tools/idea/gradle/structure/daemon/PsDaemon", "stop"));
        }
        for (MergingUpdateQueue queue : queues) {
            queue.cancelAllUpdates();
            queue.deactivate();
        }
    }

    @NotNull
    protected abstract MergingUpdateQueue getMainQueue();

    @NotNull
    protected abstract MergingUpdateQueue getResultsUpdaterQueue();

    protected boolean isStopped() {
        return this.myStopped.get();
    }

    @NotNull
    protected PsContext getContext() {
        PsContext psContext = this.myContext;
        if (psContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/android/tools/idea/gradle/structure/daemon/PsDaemon", "getContext"));
        }
        return psContext;
    }

    public abstract boolean isRunning();

    public void dispose() {
        this.stop();
    }
}

